/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor.outline.dnd;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineNodeTransfer;

public class OutlineDragListener
implements DragSourceListener {
    private TreeViewer treeViewer;

    public OutlineDragListener(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    private ISelection getSelection() {
        if (this.treeViewer == null) {
            return null;
        }
        ISelection selection = this.treeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ArrayList<Object> collector = new ArrayList<Object>();
        for (Object element : structuredSelection) {
            if (element instanceof EditPart) {
                collector.add(((EditPart)element).getModel());
                continue;
            }
            collector.add(element);
        }
        return new StructuredSelection(collector.toArray());
    }

    public void dragFinished(DragSourceEvent event) {
        OutlineNodeTransfer.getTransfer().setSelection(null);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.getSelection();
        if (selection == null) {
            event.doit = false;
        }
        OutlineNodeTransfer.getTransfer().setSelection(selection);
    }
}

