/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.problems;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xwt.vex.problems.IProblemChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemCheckerRegistry {
    public static final String EXTENSION_ID = "org.eclipse.xwt.vex.problemChecker";
    private static final String CHECKER = "class";
    public static final ProblemCheckerRegistry INSTANCE = new ProblemCheckerRegistry();
    private Map<String, IProblemChecker> name2checker = new HashMap<String, IProblemChecker>();

    private ProblemCheckerRegistry() {
    }

    public List<IProblemChecker> getCheckers(String pointId) {
        IConfigurationElement[] configElem;
        ArrayList<IProblemChecker> checkers = new ArrayList<IProblemChecker>();
        IConfigurationElement[] iConfigurationElementArray = configElem = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElem.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                IExtension parent = (IExtension)ce.getParent();
                String uniqueIdentifier = parent.getUniqueIdentifier();
                if (pointId.equals(uniqueIdentifier)) {
                    String attribute = ce.getAttribute(CHECKER);
                    IProblemChecker checker = this.name2checker.get(attribute);
                    if (checker == null) {
                        checker = (IProblemChecker)ce.createExecutableExtension(CHECKER);
                        this.name2checker.put(attribute, checker);
                    }
                    checkers.add(checker);
                }
            }
            catch (CoreException e) {
                return Collections.emptyList();
            }
            ++n2;
        }
        return checkers;
    }
}

