/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette.customize.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xwt.vex.EditorMessages;
import org.eclipse.xwt.vex.palette.customize.CustomizeComponentFactory;
import org.eclipse.xwt.vex.palette.customize.InvokeType;
import org.eclipse.xwt.vex.palette.customize.model.CustomizeComponent;

public class CustomizePaletteDialog
extends TitleAreaDialog {
    private Text textName;
    private Text textScope;
    private Text textIcon;
    private Text textLargeIcon;
    private Text textToolTip;
    private Text textContent;
    InvokeType invokeType;
    CustomizeComponent customizeComponent;
    String templateDnDText;

    public CustomizePaletteDialog(InvokeType invokeType, String componentName, String templateDnDText) {
        super(null);
        this.invokeType = invokeType;
        if (invokeType == InvokeType.Modify) {
            this.customizeComponent = CustomizeComponentFactory.loadComponent(componentName);
        }
        if (invokeType == InvokeType.DragAdd) {
            this.templateDnDText = templateDnDText;
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Rectangle screenSize = Display.getDefault().getClientArea();
        Rectangle frameSize = this.getShell().getBounds();
        this.getShell().setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setTitle(EditorMessages.CustomizePaletteDialog_Title);
        this.setMessage(EditorMessages.CustomizePaletteDialog_Message, 1);
        return contents;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EditorMessages.CustomizePaletteDialog_Header);
        newShell.setSize(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        final Composite compositeNew = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        compositeNew.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        compositeNew.setLayoutData((Object)data);
        Label labelName = new Label(compositeNew, 16384);
        labelName.setText(EditorMessages.CustomizePaletteDialog_Name);
        this.textName = new Text(compositeNew, 2052);
        data = new GridData(768);
        this.textName.setLayoutData((Object)data);
        this.textName.setToolTipText(EditorMessages.CustomizePaletteDialog_Name_ToolTip);
        Label labelScope = new Label(compositeNew, 16384);
        labelScope.setText(EditorMessages.CustomizePaletteDialog_Scope);
        this.textScope = new Text(compositeNew, 2052);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.textScope.setLayoutData((Object)data);
        this.textScope.setToolTipText(EditorMessages.CustomizePaletteDialog_Scope_ToolTip);
        Label labelIcon = new Label(compositeNew, 16384);
        labelIcon.setText(EditorMessages.CustomizePaletteDialog_Icon);
        this.textIcon = new Text(compositeNew, 2052);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.minimumWidth = 280;
        this.textIcon.setLayoutData((Object)data);
        this.textIcon.setToolTipText(EditorMessages.CustomizePaletteDialog_Icon_ToolTip);
        Button buttonBrowseIcon = new Button(compositeNew, 8);
        buttonBrowseIcon.setText(EditorMessages.CustomizePaletteDialog_BrowseIcon);
        buttonBrowseIcon.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(compositeNew.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                selectionDialog.setAllowMultiple(false);
                selectionDialog.setTitle(EditorMessages.CustomizePaletteDialog_SelectionDialog_Title);
                selectionDialog.setMessage(EditorMessages.CustomizePaletteDialog_SelectionDialog_Text);
                selectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (selectionDialog.open() == 0) {
                    IFile file = (IFile)selectionDialog.getFirstResult();
                    String workspacePath = file.getWorkspace().getRoot().getLocation().toOSString();
                    String filePath = file.getFullPath().toOSString();
                    CustomizePaletteDialog.this.textIcon.setText(String.valueOf(workspacePath) + filePath);
                }
            }
        });
        data = new GridData(768);
        data.minimumWidth = 100;
        buttonBrowseIcon.setLayoutData((Object)data);
        Label labelLargeIcon = new Label(compositeNew, 16384);
        labelLargeIcon.setText(EditorMessages.CustomizePaletteDialog_LargeIcon);
        this.textLargeIcon = new Text(compositeNew, 2052);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.textLargeIcon.setLayoutData((Object)data);
        this.textLargeIcon.setToolTipText(EditorMessages.CustomizePaletteDialog_LargeIcon_ToolTip);
        Button buttonBrowseLargeIcon = new Button(compositeNew, 8);
        buttonBrowseLargeIcon.setText(EditorMessages.CustomizePaletteDialog_BrowseLargeIcon);
        buttonBrowseLargeIcon.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(compositeNew.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                selectionDialog.setAllowMultiple(false);
                selectionDialog.setTitle(EditorMessages.CustomizePaletteDialog_SelectionDialog_LargeTitle);
                selectionDialog.setMessage(EditorMessages.CustomizePaletteDialog_SelectionDialog_LargeText);
                selectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                if (selectionDialog.open() == 0) {
                    IFile file = (IFile)selectionDialog.getFirstResult();
                    String workspacePath = file.getWorkspace().getRoot().getLocation().toOSString();
                    String filePath = file.getFullPath().toOSString();
                    CustomizePaletteDialog.this.textLargeIcon.setText(String.valueOf(workspacePath) + filePath);
                }
            }
        });
        data = new GridData(768);
        buttonBrowseLargeIcon.setLayoutData((Object)data);
        Label labelToolTip = new Label(compositeNew, 16384);
        labelToolTip.setText(EditorMessages.CustomizePaletteDialog_ToolTip);
        this.textToolTip = new Text(compositeNew, 2052);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.textToolTip.setLayoutData((Object)data);
        this.textToolTip.setToolTipText(EditorMessages.CustomizePaletteDialog_ToolTip_ToolTip);
        Label labelContent = new Label(compositeNew, 16384);
        labelContent.setText(EditorMessages.CustomizePaletteDialog_Content);
        data = new GridData(768);
        data.horizontalSpan = 5;
        labelContent.setLayoutData((Object)data);
        this.textContent = new Text(compositeNew, 2818);
        data = new GridData(1808);
        data.horizontalSpan = 5;
        this.textContent.setLayoutData((Object)data);
        this.textContent.setToolTipText(EditorMessages.CustomizePaletteDialog_Content_ToolTip);
        if (this.invokeType == InvokeType.DragAdd) {
            this.textContent.setText(this.templateDnDText);
        }
        this.setModifyComponentContent();
        return composite;
    }

    private void setModifyComponentContent() {
        if (this.invokeType == InvokeType.Modify) {
            this.textName.setText(this.customizeComponent.getName());
            this.textScope.setText(this.customizeComponent.getScope());
            this.textIcon.setText(this.customizeComponent.getIcon());
            this.textLargeIcon.setText(this.customizeComponent.getLargeIcon());
            this.textToolTip.setText(this.customizeComponent.getTooptip());
            this.textContent.setText(this.customizeComponent.getContent());
        }
    }

    protected void okPressed() {
        if (this.doAddCustomizePaletteComponent()) {
            super.okPressed();
        }
    }

    private boolean doAddCustomizePaletteComponent() {
        if (!this.validInput()) {
            return false;
        }
        CustomizeComponentFactory customizeComponentFactory = CustomizeComponentFactory.getCustomizeComponentFactory();
        if (this.invokeType != InvokeType.Modify && customizeComponentFactory.isComponentExist(this.textName.getText())) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ErrorMessage);
            return false;
        }
        if (this.invokeType == InvokeType.Modify && !this.textName.getText().equals(this.customizeComponent.getName()) && customizeComponentFactory.isComponentExist(this.textName.getText())) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ErrorMessage);
            return false;
        }
        CustomizeComponent component = new CustomizeComponent();
        component.setName(this.textName.getText());
        component.setScope(this.textScope.getText());
        component.setIcon(this.textIcon.getText());
        component.setLargeIcon(this.textLargeIcon.getText());
        component.setTooptip(this.textToolTip.getText());
        component.setContent(this.textContent.getText());
        if (this.invokeType == InvokeType.Modify) {
            customizeComponentFactory.modifyComponent(component, this.customizeComponent.getName());
        } else {
            customizeComponentFactory.addComponent(component);
        }
        return true;
    }

    private boolean validInput() {
        boolean result = true;
        if (this.textName.getText() == null || this.textName.getText().trim().equals("")) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_NameError);
            this.textName.setFocus();
            this.textName.selectAll();
            return false;
        }
        if (this.textContent.getText() == null || this.textContent.getText().trim().equals("")) {
            MessageDialog.openError(null, (String)EditorMessages.CustomizePaletteDialog_ErrorTitle, (String)EditorMessages.CustomizePaletteDialog_ContentError);
            this.textContent.setFocus();
            this.textContent.selectAll();
            return false;
        }
        return result;
    }
}

