/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.xwt.vex.dom.DomHelper;
import org.eclipse.xwt.vex.problems.Problem;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementEventsChecker
extends AbstractProblemChecker {
    @Override
    protected void checkProblems(StructuredTextEditor textEditor, String javaName, Node node, List<Problem> problems, boolean includeChildren) {
        NodeList childNodes;
        if (!this.isValid(node)) {
            return;
        }
        if (includeChildren && (childNodes = node.getChildNodes()) != null) {
            int length = childNodes.getLength();
            int i = 0;
            while (i < length) {
                Node item = childNodes.item(i);
                this.checkProblems(textEditor, javaName, item, problems, includeChildren);
                ++i;
            }
        }
        String nodeName = this.getTagName(node);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int attrLength = attributes.getLength();
        List<String> events = this.getEvents(nodeName, DomHelper.lookupNamespaceURI((Node)node));
        if (attrLength == 0 || events.isEmpty()) {
            return;
        }
        int j = 0;
        while (j < attrLength) {
            List<String> methods;
            String nodeValue;
            Node attr = attributes.item(j);
            String attrName = this.getTagName(attr);
            if (attrName != null && events.contains(attrName) && (nodeValue = attr.getNodeValue()) != null && !(methods = this.getJavaMethods(textEditor, javaName)).contains(nodeValue)) {
                Problem problem = this.createProblem(textEditor, node, "Java method \"" + nodeValue + "\" as event of \"" + nodeName + "\" not found", 3);
                problems.add(problem);
            }
            ++j;
        }
    }

    private List<String> getJavaMethods(StructuredTextEditor textEditor, String hostClassName) {
        ArrayList<String> results = new ArrayList<String>();
        IType javeType = this.getJaveType(textEditor, hostClassName);
        if (javeType != null) {
            try {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = javeType.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    results.add(method.getElementName());
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                return results;
            }
        }
        return results;
    }

    private IType getJaveType(StructuredTextEditor textEditor, String hostClassName) {
        IJavaProject javaProject = this.getJavaProject(textEditor);
        if (javaProject != null) {
            try {
                return javaProject.findType(hostClassName);
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return null;
    }

    private List<String> getEvents(String tagName, String ns) {
        ArrayList<String> events = new ArrayList<String>();
        return events;
    }

    @Override
    public boolean canChecked(StructuredTextEditor textEditor, String javaName) {
        return javaName != null && super.canChecked(textEditor, javaName);
    }
}

