/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.xwt.ui.editor.XWTEditor;
import org.eclipse.xwt.ui.utils.ImageManager;

public class XWTEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private Action previewAction;
    private Action javaAction;

    public XWTEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
        this.previewAction.setEnabled(part != null);
        this.javaAction.setEnabled(part != null);
    }

    private void createActions() {
        this.previewAction = new Action(){

            public void run() {
                StructuredTextEditor structuredTextEditor;
                IEditorPart editorPart;
                if (XWTEditorContributor.this.activeEditorPart instanceof StructuredTextEditor && (editorPart = (structuredTextEditor = (StructuredTextEditor)XWTEditorContributor.this.activeEditorPart).getEditorPart()) instanceof XWTEditor) {
                    XWTEditor editor = (XWTEditor)editorPart;
                    editor.handlePreview();
                }
            }
        };
        this.previewAction.setText("Preview");
        this.previewAction.setToolTipText("Preview");
        this.previewAction.setImageDescriptor(ImageManager.OBJ_PREVIEW);
        this.javaAction = new Action(){

            public void run() {
                StructuredTextEditor structuredTextEditor;
                IEditorPart editorPart;
                if (XWTEditorContributor.this.activeEditorPart instanceof StructuredTextEditor && (editorPart = (structuredTextEditor = (StructuredTextEditor)XWTEditorContributor.this.activeEditorPart).getEditorPart()) instanceof XWTEditor) {
                    XWTEditor editor = (XWTEditor)editorPart;
                    editor.generateCLRCodeAction();
                }
            }
        };
        this.javaAction.setText("Java");
        this.javaAction.setToolTipText("Preview");
        this.javaAction.setImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS);
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("XWT");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.previewAction);
        menu.add((IAction)this.javaAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
    }
}

