/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.resources;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xwt.tools.ui.designer.utils.StyleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageShop {
    private static final String ICON_PATH = "/icons/full";
    public static final String OBJ16 = "/icons/full/obj16/";
    public static final String TOOLS = "/icons/full/tools/";
    public static final String IMG_PREVIEW = "/icons/full/tools/preview.png";
    public static final String IMG_LAYOUT_ASSIST = "/icons/full/tools/layout_assist.gif";
    public static final String IMG_RESOURCES = "/icons/full/tools/resources.gif";
    public static final String IMG_ELEMENT = "/icons/full/tools/element.png";
    public static final String IMG_EVENT = "/icons/full/tools/event.png";
    public static final String IMG_LISTENER_METHOD = "/icons/full/tools/listener_method.gif";
    public static final String IMG_BINDING = "/icons/full/tools/binding/binding.png";
    public static final String IMG_BINDING_ADD = "/icons/full/tools/binding/binding_add.png";
    public static final String IMG_BINDING_DELETE = "/icons/full/tools/binding/binding_delete.png";
    public static final String IMG_BINDING_REMOVE_ALL = "/icons/full/tools/binding/binding_remove_all.png";
    public static final String IMG_BINDING_EDIT = "/icons/full/tools/binding/binding_edit.png";
    public static final String IMG_ARRAY = "/icons/full/tools/array.png";
    public static final String IMG_BOOLEAN = "/icons/full/tools/boolean.png";
    public static final String IMG_COLLECTION = "/icons/full/tools/collection.png";
    public static final String IMG_COLOR = "/icons/full/tools/color.png";
    public static final String IMG_FONT = "/icons/full/tools/font.png";
    public static final String IMG_IMAGE = "/icons/full/tools/image.png";
    public static final String IMG_NUMBER = "/icons/full/tools/number.png";
    public static final String IMG_OBJECT = "/icons/full/tools/object.png";
    public static final String IMG_STRING = "/icons/full/tools/string.png";
    public static final String IMG_VIEWER_COLLECTION = "/icons/full/tools/viewer_collection.png";
    public static final String IMG_VIEWER = "/icons/full/tools/viewer.png";
    public static final String IMG_CLEAR_FILTER = "/icons/full/tools/clear_filter.gif";
    public static final String IMG_CLEAR = "/icons/full/tools/clear.gif";
    public static final String IMG_BOLD = "/icons/full/tools/bold.gif";
    public static final String IMG_ITALIC = "/icons/full/tools/italic.gif";
    public static final String IMG_IMAGE_EDIT = "/icons/full/tools/image_edit.png";
    public static final String IMG_BACKGROUND_IMAGE_EDIT = "/icons/full/tools/background_image_edit.png";
    public static final String IMG_BACKGROUND_FILL_COLOR = "/icons/full/tools/background_fill_color.png";
    public static final String IMG_FOREGROUND_FILL_COLOR = "/icons/full/tools/foreground_fill_color.png";
    public static final String IMG_FONT_DELETE = "/icons/full/tools/font_delete.png";
    public static final String IMAGE_OBSERVE_BEANS = "/icons/full/tools/observe/beans.gif";
    public static final String IMAGE_OBSERVE_EMF = "/icons/full/tools/observe/emf.png";
    public static final String IMAGE_OBSERVE_OBJECT = "/icons/full/tools/observe/object.gif";
    public static final String IMAGE_OBSERVE_WIDGETS = "/icons/full/tools/observe/widgets.gif";
    public static final String IMAGE_OBSERVE_XML = "/icons/full/tools/observe/xml.gif";
    public static final String IMAGE_OBSERVE_CUSTOM = "/icons/full/tools/observe/custom.png";
    public static final String IMG_XWT = "/icons/full/tools/xaml.png";
    public static final String IMG_GOTO_DEFINITION = "/icons/full/tools/goto_definition.gif";

    public static Image get(String imageFilePath) {
        ImageDescriptor imageDesc = ImageShop.getImageDescriptor(imageFilePath);
        if (imageDesc != null) {
            return imageDesc.createImage();
        }
        return ImageShop.getImageRegistry().get(imageFilePath);
    }

    public static Image getObj16(String name) {
        return ImageShop.get(OBJ16 + name + "_obj.gif");
    }

    public static Image getImageForWidget(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        String name = widget.getClass().getSimpleName().toLowerCase();
        if ("combo".equals(name)) {
            name = "choice";
        } else if ("coolitem".endsWith(name)) {
            name = "coolbar";
        } else if ("toolitem".equals(name)) {
            if (StyleHelper.checkStyle(widget, 8)) {
                name = "toolitempush";
            } else if (StyleHelper.checkStyle(widget, 4)) {
                name = "toolitemdrop";
            } else if (StyleHelper.checkStyle(widget, 32)) {
                name = "toolitemcheck";
            } else if (StyleHelper.checkStyle(widget, 16)) {
                name = "toolitemradio";
            } else if (StyleHelper.checkStyle(widget, 2)) {
                name = "toolitemseparator";
            }
        } else if ("label".equals(name) && StyleHelper.checkStyle(widget, 2)) {
            name = "separator";
        } else if ("list".equals(name)) {
            name = "listbox";
        } else if ("button".equals(name)) {
            if (StyleHelper.checkStyle(widget, 16)) {
                name = "radiobutton";
            } else if (StyleHelper.checkStyle(widget, 32)) {
                name = "checkbox";
            } else if (StyleHelper.checkStyle(widget, 2)) {
                name = "toggledbutton";
            } else if (StyleHelper.checkStyle(widget, 4)) {
                name = "radiobutton";
            }
        }
        Image obj16 = ImageShop.getObj16(name);
        if (obj16 == null) {
            obj16 = ImageShop.getObj16("composite");
        }
        return obj16;
    }

    public static Image getImageForType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            return ImageShop.get(IMG_ARRAY);
        }
        if (type == String.class) {
            return ImageShop.get(IMG_STRING);
        }
        if (type == Color.class) {
            return ImageShop.get(IMG_COLOR);
        }
        if (type == Font.class) {
            return ImageShop.get(IMG_FONT);
        }
        if (type == Integer.TYPE || type == Integer.class || Float.TYPE == type || Float.class == type) {
            return ImageShop.get(IMG_NUMBER);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ImageShop.get(IMG_BOOLEAN);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ImageShop.get(IMG_COLLECTION);
        }
        String name = type.getSimpleName().toLowerCase();
        Image image = ImageShop.getObj16(name);
        if (image != null) {
            return image;
        }
        return ImageShop.get(IMG_OBJECT);
    }

    public static ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }

    public static ImageDescriptor getImageDescriptor(String imageFilePath) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.xwt.tools.ui.designer", (String)imageFilePath);
    }
}

