/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.xwt.converters.StringToInteger;
import org.eclipse.xwt.converters.StringToPoint;
import org.eclipse.xwt.converters.StringToRectangle;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.commands.ChangeConstraintCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ResizeCommand;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.model.RefreshAdapter;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.properties.tabbed.sections.AbstractAttributeSection;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ConstraintSection
extends AbstractAttributeSection {
    private Spinner xSpinner;
    private Spinner heightSpinner;
    private Spinner widthSpinner;
    private Spinner ySpinner;
    private int increment = 10;
    private Spinner incrementSpinner;
    private int widthCache = 0;
    private int heightCache = 0;

    protected String getAttributeName() {
        return "";
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite comp = this.getWidgetFactory().createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.getWidgetFactory().createLabel(comp, "Increment of spinner:");
        this.incrementSpinner = this.createSpinner(comp);
        this.incrementSpinner.setIncrement(1);
        this.incrementSpinner.setMaximum(100);
        this.incrementSpinner.setMinimum(1);
        this.incrementSpinner.setSelection(this.increment);
    }

    protected void createClearButton(Composite parent) {
    }

    protected Control createSection(Composite parent) {
        Composite control = this.getWidgetFactory().createComposite(parent);
        control.setLayout((Layout)new GridLayout(2, false));
        Group locationGroup = this.getWidgetFactory().createGroup(control, "Location");
        locationGroup.setLayout((Layout)new GridLayout(4, false));
        this.getWidgetFactory().createLabel((Composite)locationGroup, "x");
        this.xSpinner = this.createSpinner((Composite)locationGroup);
        this.getWidgetFactory().createLabel((Composite)locationGroup, "y");
        this.ySpinner = this.createSpinner((Composite)locationGroup);
        Group sizeGroup = this.getWidgetFactory().createGroup(control, "Size");
        sizeGroup.setLayout((Layout)new GridLayout(4, false));
        this.getWidgetFactory().createLabel((Composite)sizeGroup, "width");
        this.widthSpinner = this.createSpinner((Composite)sizeGroup);
        this.getWidgetFactory().createLabel((Composite)sizeGroup, "height");
        this.heightSpinner = this.createSpinner((Composite)sizeGroup);
        return control;
    }

    private Spinner createSpinner(Composite parent) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMaximum(Integer.MAX_VALUE);
        spinner.setMinimum(-1);
        spinner.addListener(13, (Listener)this);
        spinner.setLayoutData((Object)new GridData(768));
        spinner.setIncrement(this.increment);
        return spinner;
    }

    public void doRefresh() {
        Rectangle r = this.getModelValue();
        if (r == null) {
            return;
        }
        if (this.xSpinner != null && !this.xSpinner.isDisposed() && r.x != this.xSpinner.getSelection()) {
            this.xSpinner.removeListener(13, (Listener)this);
            this.xSpinner.setSelection(r.x);
            this.xSpinner.addListener(13, (Listener)this);
        }
        if (this.ySpinner != null && !this.ySpinner.isDisposed() && r.y != this.ySpinner.getSelection()) {
            this.ySpinner.removeListener(13, (Listener)this);
            this.ySpinner.setSelection(r.y);
            this.ySpinner.addListener(13, (Listener)this);
        }
        if (this.widthSpinner != null && !this.widthSpinner.isDisposed() && r.width != this.widthSpinner.getSelection()) {
            this.widthSpinner.removeListener(13, (Listener)this);
            this.widthSpinner.setSelection(r.width);
            this.widthSpinner.addListener(13, (Listener)this);
        }
        if (this.heightSpinner != null && !this.heightSpinner.isDisposed() && r.height != this.heightSpinner.getSelection()) {
            this.heightSpinner.removeListener(13, (Listener)this);
            this.heightSpinner.setSelection(r.height);
            this.heightSpinner.addListener(13, (Listener)this);
        }
        this.widthCache = r.width;
        this.heightCache = r.height;
        LayoutType containerLayout = this.getContainerLayout();
        if (LayoutType.Unknown == containerLayout || LayoutType.NullLayout == containerLayout) {
            this.xSpinner.setEnabled(true);
            this.ySpinner.setEnabled(true);
        } else {
            this.xSpinner.setEnabled(false);
            this.ySpinner.setEnabled(false);
        }
    }

    private Rectangle getModelValue() {
        Rectangle r = new Rectangle(-1, -1, -1, -1);
        LayoutType containerLayout = this.getContainerLayout();
        XamlNode parent = this.getParent();
        if (parent == null) {
            return r;
        }
        if (LayoutType.NullLayout == containerLayout) {
            XamlAttribute attribute = parent.getAttribute("bounds");
            if (attribute != null && attribute.getValue() != null) {
                org.eclipse.swt.graphics.Rectangle rect = (org.eclipse.swt.graphics.Rectangle)StringToRectangle.instance.convert((Object)attribute.getValue());
                r.setLocation(rect.x, rect.y);
                r.setSize(rect.width, rect.height);
            } else {
                attribute = parent.getAttribute("location");
                if (attribute != null && attribute.getValue() != null) {
                    Point location = (Point)StringToPoint.instance.convert((Object)attribute.getValue());
                    r.setLocation(location.x, location.y);
                }
                if ((attribute = parent.getAttribute("size")) != null && attribute.getValue() != null) {
                    Point size = (Point)StringToPoint.instance.convert((Object)attribute.getValue());
                    r.setSize(size.x, size.y);
                }
            }
        } else if (LayoutType.Unknown != containerLayout) {
            WidgetEditPart editPart = this.getEditPart();
            Widget widget = editPart.getWidget();
            IMetaclass metaclass = XWTUtility.getMetaclass(parent);
            XamlAttribute widthAttr = parent.getAttribute("width");
            if (widthAttr != null) {
                r.width = (Integer)StringToInteger.instance.convert((Object)widthAttr.getValue());
            } else if (metaclass != null) {
                try {
                    IProperty widthProperty = metaclass.findProperty("width");
                    if (widthProperty != null) {
                        r.width = (Integer)widthProperty.getValue((Object)widget);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            XamlAttribute heightAttr = parent.getAttribute("height");
            if (heightAttr != null) {
                r.height = (Integer)StringToInteger.instance.convert((Object)heightAttr.getValue());
            } else if (metaclass != null) {
                try {
                    IProperty heightProperty = metaclass.findProperty("height");
                    if (heightProperty != null) {
                        r.height = (Integer)heightProperty.getValue((Object)widget);
                    }
                }
                catch (Exception e) {
                    System.out.println();
                }
            }
        }
        return r;
    }

    private LayoutType getContainerLayout() {
        WidgetEditPart editPart = this.getEditPart();
        if (editPart == null) {
            return null;
        }
        return LayoutsHelper.getLayoutType(editPart.getParent());
    }

    public void handleEvent(Event event) {
        if (event.widget == this.incrementSpinner) {
            this.increment = this.incrementSpinner.getSelection();
            this.xSpinner.setIncrement(this.increment);
            this.ySpinner.setIncrement(this.increment);
            this.widthSpinner.setIncrement(this.increment);
            this.heightSpinner.setIncrement(this.increment);
            return;
        }
        LayoutType containerLayout = this.getContainerLayout();
        if (LayoutType.NullLayout == containerLayout) {
            Rectangle r = new Rectangle();
            r.x = this.xSpinner.getSelection();
            r.y = this.ySpinner.getSelection();
            r.width = this.widthCache = this.widthSpinner.getSelection();
            r.height = this.heightCache = this.heightSpinner.getSelection();
            ChangeConstraintCommand cmd = new ChangeConstraintCommand((EditPart)this.getEditPart(), r);
            this.executeCommand(cmd);
        } else if (LayoutType.Unknown != containerLayout) {
            Dimension growth = new Dimension();
            if (event.widget == this.widthSpinner) {
                growth.width = this.widthSpinner.getSelection() - this.widthCache;
                this.widthCache = this.widthSpinner.getSelection();
            } else if (event.widget == this.heightSpinner) {
                growth.height = this.heightSpinner.getSelection() - this.heightCache;
                this.heightCache = this.heightSpinner.getSelection();
            }
            ResizeCommand cmd = new ResizeCommand((EditPart)this.getEditPart(), growth);
            this.executeCommand(cmd);
        }
    }

    protected RefreshAdapter getRefresher() {
        RefreshAdapter refresher = super.getRefresher();
        refresher.addListenedAttr("bounds");
        refresher.addListenedAttr("size");
        refresher.addListenedAttr("location");
        refresher.addListenedAttr("width");
        refresher.addListenedAttr("height");
        return refresher;
    }

    protected String getNewValue(Event event) {
        return null;
    }
}

