/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.commands.AddItemsCommand;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ChangeLayoutCommand;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.core.properties.LabelProviderFactory;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyContext {
    private EditPart editPart;
    private XamlNode node;
    private EditDomain editDomain;
    private String category = "Attributes";
    private PropertyContext parent;

    public PropertyContext(EditPart editPart, PropertyContext parent) {
        this((XamlNode)null, parent);
        Assert.isNotNull((Object)editPart);
        this.editPart = editPart;
    }

    public PropertyContext(XamlNode node, PropertyContext parent) {
        this.node = node;
        this.parent = parent;
    }

    public Object getComponent() {
        if (this.editPart == null) {
            return null;
        }
        if (this.editPart instanceof WidgetEditPart) {
            return ((WidgetEditPart)this.editPart).getWidget();
        }
        if (this.editPart instanceof ViewerEditPart) {
            return ((ViewerEditPart)this.editPart).getViewer();
        }
        return null;
    }

    public Class<?> getType() {
        IMetaclass metaclass = this.getMetaclass();
        if (metaclass != null) {
            return metaclass.getType();
        }
        throw new NullPointerException("Unknown object type");
    }

    public IMetaclass getMetaclass() {
        Object component;
        IMetaclass metaclass = null;
        if (this.node != null) {
            metaclass = XWTUtility.getMetaclass(this.node);
        }
        if (metaclass == null && (component = this.getComponent()) != null) {
            metaclass = XWT.getMetaclass((Object)component);
        }
        return metaclass;
    }

    public XamlNode getNode() {
        Object model;
        if (this.node == null && this.editPart != null && (model = this.editPart.getModel()) instanceof XamlNode) {
            this.node = (XamlNode)model;
        }
        return this.node;
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public EditDomain getEditDomain() {
        if (this.editDomain == null && this.parent != null) {
            this.editDomain = this.parent.getEditDomain();
        }
        return this.editDomain;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public PropertyContext getParent() {
        return this.parent;
    }

    public boolean isDirectEditType(Class<?> type) {
        return type.isPrimitive() || String.class == type || Color.class == type || Font.class == type || Rectangle.class == type || Point.class == type || Image.class == type || Boolean.class == type || Character.class == type || Integer.class == type || Long.class == type || Double.class == type || Float.class == type || Byte.class == type;
    }

    public void setPropertyValue(Object id, Object value) {
        this.execute(this.createSetValueCommand(id, value));
    }

    private Command createSetValueCommand(Object id, Object value) {
        CompoundCommand cmd = new CompoundCommand();
        IProperty property = (IProperty)id;
        Class type = property.getType();
        if (this.isDirectEditType(type)) {
            ILabelProvider lp = LabelProviderFactory.getLabelProvider((Class)type);
            cmd.add((Command)new ApplyAttributeSettingCommand(this.node, property.getName(), "http://www.eclipse.org/xwt/presentation", lp.getText(value)));
            XamlNode parentNode = this.parent == null ? null : this.parent.getNode();
            XamlNode current = this.node;
            XamlNode container = (XamlNode)current.eContainer();
            if (parentNode != null) {
                while (container != null && container != parentNode) {
                    current = container;
                    container = (XamlNode)current.eContainer();
                }
                if (container == null) {
                    container = parentNode;
                    cmd.add((Command)new AddNewChildCommand(container, current));
                }
            }
        } else if (Layout.class == type && this.editPart != null) {
            cmd.add((Command)new ChangeLayoutCommand(this.editPart, LayoutsHelper.getLayoutType(value)));
        } else if (type.isArray() && type.getComponentType() == String.class && value.getClass() == String[].class) {
            cmd.add((Command)new AddItemsCommand((XamlElement)this.node, (String[])value));
        }
        return cmd.unwrap();
    }

    private void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        EditDomain editDomain = this.getEditDomain();
        if (editDomain == null || editDomain.getCommandStack() == null) {
            command.execute();
        } else {
            editDomain.getCommandStack().execute(command);
        }
    }
}

