/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.wizards.ExternalizeStringsWizard;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueModel;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class OpenExternalizeStringsAction
extends WorkbenchPartAction {
    int index = 0;
    XWTDesigner designer = (XWTDesigner)this.getWorkbenchPart();
    public static final String ID = OpenExternalizeStringsAction.class.getName();

    public OpenExternalizeStringsAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText("Externalize Strings");
    }

    public void run() {
        TextValueModel textValueEntrys = this.getTextValue();
        if (textValueEntrys.elements().length == 0) {
            String dialogMessage = "No Strings to externalize found in file.";
            String[] dialogButtonLabels = new String[]{"Ok"};
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Externalize Strings", null, dialogMessage, 2, dialogButtonLabels, 0);
            messageDialog.open();
        } else {
            ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(textValueEntrys, this.designer);
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    protected TextValueModel getTextValue() {
        TextValueModel textValueEntrys = new TextValueModel();
        this.index = 0;
        RootEditPart rootEditPart = this.designer.getGraphicalViewer().getRootEditPart();
        EditPart contents = rootEditPart.getContents();
        this.getTextContents(contents, textValueEntrys, "text");
        this.getTextContents(contents, textValueEntrys, "tooltipText");
        return textValueEntrys;
    }

    private void getTextContents(EditPart editPart, TextValueModel textValueEntrys, String type) {
        if (editPart instanceof WidgetEditPart) {
            XamlNode node = ((WidgetEditPart)editPart).getCastModel();
            XamlAttribute attribute = node.getAttribute(type, "http://www.eclipse.org/xwt/presentation");
            if (attribute != null && attribute.getChildNodes().size() == 0) {
                textValueEntrys.add(new TextValueEntry(attribute.getValue(), "" + this.index));
                ++this.index;
            }
            if (editPart.getChildren().size() > 0) {
                this.getChildTextContents(editPart, textValueEntrys, type);
            }
        } else if (editPart.getChildren().size() > 0) {
            this.getChildTextContents(editPart, textValueEntrys, type);
        }
    }

    private void getChildTextContents(EditPart editPart, TextValueModel textValueEntrys, String type) {
        if (editPart.getChildren().size() > 0) {
            List child = editPart.getChildren();
            int i = 0;
            while (i < child.size()) {
                if (child.get(i) instanceof EditPart) {
                    this.getTextContents((EditPart)child.get(i), textValueEntrys, type);
                }
                ++i;
            }
        }
    }

    protected boolean calculateEnabled() {
        return true;
    }
}

