/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.SWT;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;

public class CutElementAction
extends SelectionAction {
    private XWTDesigner editorPart;

    public CutElementAction(IWorkbenchPart part) {
        super(part);
        this.editorPart = (XWTDesigner)part;
        this.setText(WorkbenchMessages.Workbench_cut);
        this.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
        this.setId(ActionFactory.CUT.getId());
        this.setAccelerator(SWT.MOD1 | 0x78);
        ISharedImages sharedImages = part.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
    }

    protected boolean calculateEnabled() {
        boolean result;
        if (this.editorPart == null) {
            return false;
        }
        if (this.editorPart.getGraphicalViewer() == null) {
            return false;
        }
        List selectedEditParts = this.editorPart.getGraphicalViewer().getSelectedEditParts();
        boolean bl = result = selectedEditParts != null && !selectedEditParts.isEmpty();
        if (result) {
            for (EditPart editPart : selectedEditParts) {
                EObject eObject;
                Object object = editPart.getModel();
                if (!(object instanceof EObject) || (eObject = (EObject)object).eContainer() != null) continue;
                return false;
            }
        }
        return result;
    }

    public void run() {
        List selectedEditParts = this.editorPart.getGraphicalViewer().getSelectedEditParts();
        ArrayList<XamlElement> selectResult = new ArrayList<XamlElement>();
        for (EditPart part : selectedEditParts) {
            Object model = part.getModel();
            if (!(model instanceof XamlElement)) continue;
            XamlElement copymodel = (XamlElement)EcoreUtil.copy((EObject)((XamlElement)model));
            selectResult.add(copymodel);
        }
        if (selectResult != null && selectResult.size() != 0) {
            Clipboard.getDefault().setContents(selectResult);
        }
        DeleteCommand dcmd = new DeleteCommand(selectedEditParts);
        this.editorPart.getEditDomain().getCommandStack().execute((Command)dcmd);
    }
}

