/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingHelper;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.AdvancedBindingDialog;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.BindingTableGroup;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.IGroup;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.ObserveModelGroup;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.ObserveTargetGroup;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public class DatabindingGroup
implements IGroup {
    private ObserveTargetGroup targetComp;
    private ObserveModelGroup modelComp;
    private Button bindingAction;
    private BindingTableGroup bindingsTableGroup;
    private static final String ACTION_TOOLTIP_TEXT = "Create data binding use this selection";
    private static final String ACTION_TOOLTIP_MESSAGE = "Use Ctrl for create binding without dialog(if this is possible)";
    private Composite targetGroup;
    private Composite modelGroup;
    private CommandStack commandStack;
    private BindingContext bindingContext;
    private Object input;

    public DatabindingGroup(CommandStack commandStack, BindingContext bindingContext) {
        this.commandStack = commandStack;
        this.bindingContext = bindingContext;
    }

    public Composite createGroup(Composite control, int style) {
        Composite group = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Label label = new Label(group, 0);
        label.setText("Bound properties");
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.bindingsTableGroup = new BindingTableGroup(this.commandStack);
        Composite table = this.bindingsTableGroup.createGroup(group, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        table.setLayoutData((Object)layoutData);
        this.bindingsTableGroup.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BindingInfo selection = DatabindingGroup.this.bindingsTableGroup.getSelection();
                DatabindingGroup.this.handleSelection(selection);
            }
        });
        GridData sepGd = new GridData(768);
        sepGd.horizontalIndent = 5;
        sepGd.horizontalSpan = 3;
        new Label(group, 258).setLayoutData((Object)sepGd);
        this.targetComp = new ObserveTargetGroup(this.bindingContext, null);
        this.bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DatabindingGroup.this.updateBindingAction();
            }
        });
        this.targetGroup = this.targetComp.createGroup(group, 0);
        this.targetGroup.setLayoutData((Object)new GridData(1808));
        this.targetGroup.setToolTipText("please select a operation");
        Composite separator = this.createButtonSeparator(group);
        int gdStyle = 1040;
        separator.setLayoutData((Object)new GridData(gdStyle));
        this.modelComp = new ObserveModelGroup(this.bindingContext, null);
        this.modelGroup = this.modelComp.createGroup(group, 0);
        this.modelGroup.setLayoutData((Object)new GridData(1808));
        return group;
    }

    protected void handleSelection(BindingInfo binding) {
        if (binding == null) {
            return;
        }
        BindingContext bc = binding.getBindingContext();
        this.bindingContext.setModel(bc.getModel());
        this.bindingContext.setModelProperty(bc.getModelProperty());
        this.bindingContext.setTarget(bc.getTarget());
        this.bindingContext.setTargetProperty(bc.getTargetProperty());
        this.bindingAction.setEnabled(false);
    }

    private Composite createButtonSeparator(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        int orientation = 514;
        int gdStyle = 1104;
        new Label(control, orientation).setLayoutData((Object)new GridData(gdStyle));
        this.bindingAction = new Button(control, 8);
        this.bindingAction.setToolTipText("Create data binding use this selection\nUse Ctrl for create binding without dialog(if this is possible)");
        this.bindingAction.setImage(ImageShop.get("/icons/full/tools/binding/binding_add.png"));
        this.bindingAction.setEnabled(false);
        Listener listener = new Listener(){
            private boolean useCtrl = false;

            public void handleEvent(Event e) {
                if (1 == e.type) {
                    if (!this.useCtrl && e.keyCode == 262144) {
                        this.useCtrl = true;
                    }
                } else if (2 == e.type) {
                    if (this.useCtrl && e.keyCode == 262144) {
                        this.useCtrl = false;
                    }
                } else if (13 == e.type) {
                    DatabindingGroup.this.createDataBindings(this.useCtrl);
                } else if (12 == e.type) {
                    e.display.removeFilter(2, (Listener)this);
                    e.display.removeFilter(1, (Listener)this);
                }
            }
        };
        Display display = this.bindingAction.getDisplay();
        display.addFilter(1, listener);
        display.addFilter(2, listener);
        this.bindingAction.addListener(13, listener);
        this.bindingAction.addListener(12, listener);
        new Label(control, orientation).setLayoutData((Object)new GridData(gdStyle));
        return control;
    }

    protected void updateBindingAction() {
        if (this.bindingAction == null || this.bindingAction.isDisposed()) {
            return;
        }
        this.bindingAction.setEnabled(this.bindingContext.isValid());
    }

    protected void createDataBindings(boolean useCtrl) {
        BindingInfo bindingInfo = new BindingInfo(this.bindingContext);
        if (useCtrl) {
            this.createBinding(bindingInfo);
        } else {
            AdvancedBindingDialog dialog = new AdvancedBindingDialog(new Shell(), bindingInfo);
            if (dialog.open() == 0) {
                this.createBinding(bindingInfo);
            }
        }
    }

    private void createBinding(BindingInfo bindingInfo) {
        Command bindCmd = bindingInfo.bindWithCommand();
        if (bindCmd != null) {
            if (this.commandStack != null) {
                this.commandStack.execute(bindCmd);
            } else if (bindCmd.canExecute()) {
                bindCmd.execute();
            }
            if (this.input == null || !(this.input instanceof EditPart)) {
                return;
            }
            DisplayUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    List<BindingInfo> bindings = BindingHelper.getBindings((EditPart)DatabindingGroup.this.input);
                    DatabindingGroup.this.bindingsTableGroup.setInput(bindings);
                }
            });
        }
    }

    public void setInput(Object input) {
        if (input == null || !(input instanceof EditPart)) {
            return;
        }
        this.input = input;
        EditPart editPart = (EditPart)input;
        List<BindingInfo> bindings = BindingHelper.getBindings(editPart);
        if (bindings != null && this.bindingsTableGroup != null) {
            this.bindingsTableGroup.setInput(bindings);
        }
        if (this.targetComp != null) {
            this.targetComp.setRootEditPart(editPart);
        }
        if (this.modelComp != null) {
            this.modelComp.setRootEditPart(editPart);
        }
    }
}

