/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.commands.LayoutCommandsFactory;
import org.eclipse.xwt.tools.ui.designer.commands.NoOpCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ResizeCommand;
import org.eclipse.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.xwt.tools.ui.designer.editor.palette.InitializeHelper;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayoutCommandsFactory
extends LayoutCommandsFactory {
    public GridLayoutCommandsFactory(CompositeEditPart host) {
        super((EditPart)host);
    }

    public Command getCreateCommand(List<XamlNode> constraints, List<XamlNode> children, Object beforeObject) {
        return new CreationCommand(constraints, children, beforeObject);
    }

    public Command getAddCommand(List<XamlNode> constraints, List<XamlNode> children, Object beforeObject) {
        return this.getCreateCommand(constraints, children, beforeObject);
    }

    public Command getMoveChildrenCommand(List<XamlNode> children, XamlNode before) {
        if (children == null) {
            return NoOpCommand.INSTANCE;
        }
        return new MoveChildrenCommand(children, before);
    }

    public Command getDeleteDependentCommand(List<XamlNode> deletedComponents) {
        return new DeleteCommand(deletedComponents);
    }

    public Command getOrphanChildrenCommand(final List<XamlNode> orphanedComponents) {
        return new Command(){

            public void execute() {
                System.out.println(orphanedComponents);
            }
        };
    }

    public Command getResizeChildrenCommand(EditPart child, ChangeBoundsRequest request) {
        return new ResizeCommand(child, request.getSizeDelta());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CreationCommand
    extends Command {
        private List<XamlNode> children;
        private Object beforeObject;
        private CompoundCommand cmd;

        public CreationCommand(List<XamlNode> constraints, List<XamlNode> children, Object beforeObject) {
            this.children = children;
            this.beforeObject = beforeObject;
        }

        public boolean canExecute() {
            XamlNode model = GridLayoutCommandsFactory.this.getModel();
            if (model == null || this.children == null || this.children.isEmpty()) {
                return false;
            }
            for (XamlNode child : this.children) {
                if (CreateReqHelper.canCreate(model, child)) continue;
                return false;
            }
            return true;
        }

        public void execute() {
            int index = -1;
            if (this.beforeObject != null) {
                index = GridLayoutCommandsFactory.this.getModel().getChildNodes().indexOf(this.beforeObject);
            }
            this.cmd = new CompoundCommand();
            for (XamlNode child : this.children) {
                if (!InitializeHelper.checkValue(child)) break;
                this.cmd.add((Command)new AddNewChildCommand(GridLayoutCommandsFactory.this.getModel(), child, index));
            }
            this.cmd.execute();
        }

        public boolean canUndo() {
            return this.cmd != null && this.cmd.canUndo();
        }

        public void undo() {
            if (this.cmd != null) {
                this.cmd.undo();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MoveChildrenCommand
    extends Command {
        private List<XamlNode> children;
        private XamlNode insertBeforeValue;
        private int insertAt = -1;
        private Map<XamlElement, Integer> moved = null;

        public MoveChildrenCommand(List<XamlNode> children, XamlNode insertBeforeValue) {
            this.children = children;
            this.insertBeforeValue = insertBeforeValue;
        }

        public boolean canExecute() {
            return GridLayoutCommandsFactory.this.getModel() != null && this.children != null;
        }

        public void execute() {
            EList childNodes = GridLayoutCommandsFactory.this.getModel().getChildNodes();
            ArrayList<XamlNode> orderedChildren = new ArrayList<XamlNode>((Collection<XamlNode>)childNodes);
            orderedChildren.removeAll(this.children);
            if (this.insertBeforeValue != null) {
                this.insertAt = orderedChildren.indexOf(this.insertBeforeValue);
            }
            if (this.insertAt != -1) {
                orderedChildren.addAll(this.insertAt, this.children);
            } else {
                orderedChildren.addAll(this.children);
            }
            this.moved = new HashMap<XamlElement, Integer>();
            for (XamlElement child : new ArrayList(childNodes)) {
                int oldPosition;
                int newPosition = orderedChildren.indexOf(child);
                if (newPosition == (oldPosition = childNodes.indexOf((Object)child))) continue;
                this.moved.put((XamlElement)childNodes.move(newPosition, oldPosition), oldPosition);
            }
        }

        public boolean canUndo() {
            return GridLayoutCommandsFactory.this.getModel() != null && this.moved != null && !this.moved.isEmpty();
        }

        public void undo() {
            EList childNodes = GridLayoutCommandsFactory.this.getModel().getChildNodes();
            for (XamlElement child : this.moved.keySet()) {
                int oldPosition;
                int newPosition = this.moved.get(child);
                if (newPosition == (oldPosition = childNodes.indexOf((Object)child))) continue;
                childNodes.move(newPosition, oldPosition);
            }
            this.moved.clear();
            this.moved = null;
        }
    }
}

