/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import java.io.Serializable;
import org.eclipse.xwt.animation.OutParameter;
import org.eclipse.xwt.animation.ParseNumbers;
import org.eclipse.xwt.animation.StringParser;

public class TimeSpan
implements Serializable,
Comparable {
    public static final long TicksPerMillisecond = 10000L;
    private static final double MillisecondsPerTick = 1.0E-4;
    public static final long TicksPerSecond = 10000000L;
    private static final double SecondsPerTick = 1.0E-7;
    public static final long TicksPerMinute = 600000000L;
    private static final double MinutesPerTick = 1.6666666666666667E-9;
    public static final long TicksPerHour = Long.valueOf("861c46800", 16);
    private static final double HoursPerTick = 2.7777777777777777E-11;
    public static final long TicksPerDay = Long.valueOf("c92a69c000", 16);
    private static final double DaysPerTick = 1.1574074074074074E-12;
    private static final int MillisPerSecond = 1000;
    private static final int MillisPerMinute = 60000;
    private static final int MillisPerHour = 3600000;
    private static final int MillisPerDay = 86400000;
    private static final long MaxSeconds = Long.valueOf("d6bf94d5e5", 16);
    private static final long MinSeconds = Long.valueOf("-922337203685", 10);
    private static final long MaxMilliSeconds = Long.valueOf("346dc5d638865", 16);
    private static final long MinMilliSeconds = Long.valueOf("-922337203685477", 10);
    public static final long SencondsPerHour = 3600L;
    public static final long HoursPerDay = 24L;
    public static final TimeSpan Zero;
    public static final TimeSpan MaxValue;
    public static final TimeSpan MinValue;
    public static final String TimeSpan;
    public long ticks;

    static {
        TimeSpan = null;
        Zero = new TimeSpan(0L);
        MaxValue = new TimeSpan(Long.valueOf("7fffffffffffffff", 16));
        MinValue = new TimeSpan(MinMilliSeconds);
    }

    public TimeSpan(long ticks) {
        this.ticks = ticks;
    }

    public TimeSpan(int hours, int minutes, int seconds) throws Exception {
        this.ticks = org.eclipse.xwt.animation.TimeSpan.timeToTicks(hours, minutes, seconds);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) throws Exception {
        this(days, hours, minutes, seconds, 0);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) throws Exception {
        long num = 1000L * (3600L * (long)days * 24L + (long)hours * 3600L + (long)minutes * 60L + (long)seconds) + (long)milliseconds;
        if (num > Long.valueOf(MaxMilliSeconds) || num < Long.valueOf(MinMilliSeconds)) {
            throw new Exception("Overflow_TimeSpanTooLong");
        }
        this.ticks = num * 10000L;
    }

    public long getTicks() {
        return this.ticks;
    }

    public int getDays() {
        return (int)(this.ticks / Long.valueOf(TicksPerDay));
    }

    public int getHours() {
        return (int)(this.ticks / Long.valueOf(TicksPerHour) % 24L);
    }

    public int getMilliseconds() {
        return (int)(this.ticks / 10000L);
    }

    public int getMinutes() {
        return (int)(this.ticks / 600000000L % 60L);
    }

    public int getSeconds() {
        return (int)(this.ticks / 10000000L % 60L);
    }

    public double getTotalDays() {
        return (double)this.ticks * 1.1574074074074074E-12;
    }

    public double getTotalHours() {
        return (double)this.ticks * 2.7777777777777777E-11;
    }

    public double getTotalMilliseconds() {
        double num = (double)this.ticks * 1.0E-4;
        if (num > (double)Long.valueOf(MaxMilliSeconds).longValue()) {
            return Long.valueOf(MaxMilliSeconds).longValue();
        }
        if (num < (double)Long.valueOf(MinMilliSeconds).longValue()) {
            return Long.valueOf(MinMilliSeconds).longValue();
        }
        return num;
    }

    public double getTotalMinutes() {
        return (double)this.ticks * 1.6666666666666667E-9;
    }

    public double getTotalSeconds() {
        return (double)this.ticks * 1.0E-7;
    }

    public TimeSpan add(TimeSpan ts) throws Exception {
        long ticks = this.ticks + ts.ticks;
        if (this.ticks >> 63 == ts.ticks >> 63 && this.ticks >> 63 != ticks >> 63) {
            throw new Exception("Overflow_TimeSpan Too Long");
        }
        return new TimeSpan(ticks);
    }

    public static int compare(TimeSpan t1, TimeSpan t2) {
        if (t1.ticks > t2.ticks) {
            return 1;
        }
        if (t1.ticks < t2.ticks) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object value) {
        if (value == null) {
            return 1;
        }
        if (!(value instanceof TimeSpan)) {
            throw new RuntimeException("Arg_MustBeTimeSpan");
        }
        long num = ((TimeSpan)value).ticks;
        if (this.ticks > num) {
            return 1;
        }
        if (this.ticks < num) {
            return -1;
        }
        return 0;
    }

    public static TimeSpan fromDays(double value) throws Exception {
        return org.eclipse.xwt.animation.TimeSpan.interval(value, 86400000);
    }

    public TimeSpan duration() throws Exception {
        if (this.ticks == org.eclipse.xwt.animation.TimeSpan.MinValue.ticks) {
            throw new Exception("Overflow_Duration");
        }
        return new TimeSpan(this.ticks >= 0L ? this.ticks : -this.ticks);
    }

    public boolean equals(Object value) {
        if (value instanceof TimeSpan) {
            return this.ticks == ((TimeSpan)value).ticks;
        }
        return false;
    }

    public static boolean equals(TimeSpan t1, TimeSpan t2) {
        return t1.ticks == t2.ticks;
    }

    public int hashCode() {
        return (int)this.ticks ^ (int)(this.ticks >> 32);
    }

    public static TimeSpan fromHours(double value) throws Exception {
        return org.eclipse.xwt.animation.TimeSpan.interval(value, 3600000);
    }

    private static TimeSpan interval(double value, int scale) throws Exception {
        if (Double.isNaN(value)) {
            throw new Exception("Arg_CannotBeNaN");
        }
        double num = value * (double)scale;
        if (num > (double)Long.valueOf(MaxMilliSeconds).longValue() || num < (double)Long.valueOf(MinMilliSeconds).longValue()) {
            throw new Exception("Overflow_TimeSpanTooLong");
        }
        return new TimeSpan((long)(num * 10000.0));
    }

    public static TimeSpan fromMilliseconds(double value) throws Exception {
        return org.eclipse.xwt.animation.TimeSpan.interval(value, 1);
    }

    public static TimeSpan fromMinutes(double value) throws Exception {
        return org.eclipse.xwt.animation.TimeSpan.interval(value, 60000);
    }

    public TimeSpan negate() throws Exception {
        if (this.ticks == org.eclipse.xwt.animation.TimeSpan.MinValue.ticks) {
            throw new Exception("Overflow_NegateTwosCompNum");
        }
        return new TimeSpan(-this.ticks);
    }

    public static TimeSpan parse(String s) {
        StringParser parser = new StringParser();
        return new TimeSpan(parser.parse(s));
    }

    public static boolean tryParse(String s, OutParameter result) {
        StringParser parser = new StringParser();
        long num = 0L;
        OutParameter out = new OutParameter(num);
        if (parser.tryParse(s, out)) {
            result.timeSpan = new TimeSpan(out.value);
            return true;
        }
        result.timeSpan = new TimeSpan(0L);
        return false;
    }

    public static TimeSpan fromSeconds(double value) throws Exception {
        return org.eclipse.xwt.animation.TimeSpan.interval(value, 1000);
    }

    public TimeSpan subtract(TimeSpan ts) throws Exception {
        long ticks = this.ticks - ts.ticks;
        if (this.ticks >> 63 != ts.ticks >> 63 && this.ticks >> 63 != ticks >> 63) {
            throw new Exception("Overflow_TimeSpanTooLong");
        }
        return new TimeSpan(ticks);
    }

    public static TimeSpan fromTicks(long value) {
        return new TimeSpan(value);
    }

    public static long timeToTicks(int hour, int minute, int second) throws Exception {
        long num = 3600L * (long)hour + (long)minute * 60L + (long)second;
        if (num > Long.valueOf(MaxSeconds) || num < Long.valueOf(MinSeconds)) {
            throw new Exception("Overflow_TimeSpanTooLong");
        }
        return num * 10000000L;
    }

    private String intToString(int n, int digits) {
        return ParseNumbers.intToString(n, 10, digits, '\u0000', 0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int num = (int)(this.ticks / Long.valueOf(TicksPerDay));
        long num2 = this.ticks % Long.valueOf(TicksPerDay);
        if (this.ticks < 0L) {
            builder.append("-");
            num = -num;
            num2 = -num2;
        }
        if (num != 0) {
            builder.append(num);
            builder.append(".");
        }
        builder.append(this.intToString((int)(num2 / Long.valueOf(TicksPerHour) % 24L), 2));
        builder.append(":");
        builder.append(this.intToString((int)(num2 / 600000000L % 60L), 2));
        builder.append(":");
        builder.append(this.intToString((int)(num2 / 10000000L % 60L), 2));
        int n = (int)(num2 % 10000000L);
        if (n != 0) {
            builder.append(".");
            builder.append(this.intToString(n, 7));
        }
        return builder.toString();
    }

    public static TimeSpan operatorMinus(TimeSpan t) throws Exception {
        if (t.ticks == org.eclipse.xwt.animation.TimeSpan.MinValue.ticks) {
            throw new Exception("Overflow_NegateTwosCompNum");
        }
        return new TimeSpan(-t.ticks);
    }

    public static TimeSpan operatorMinus(TimeSpan t1, TimeSpan t2) throws Exception {
        return t1.subtract(t2);
    }

    public static TimeSpan operatorPlus(TimeSpan t) {
        return t;
    }

    public static TimeSpan operatorPlus(TimeSpan t1, TimeSpan t2) throws Exception {
        return t1.add(t2);
    }

    public static boolean operatorEqual(TimeSpan t1, TimeSpan t2) {
        return t1.ticks == t2.ticks;
    }

    public static boolean operatorNotEqual(TimeSpan t1, TimeSpan t2) {
        return t1.ticks != t2.ticks;
    }

    public static boolean operatorLess(TimeSpan t1, TimeSpan t2) {
        return t1.ticks < t2.ticks;
    }

    public static boolean operatorLessEqual(TimeSpan t1, TimeSpan t2) {
        return t1.ticks <= t2.ticks;
    }

    public static boolean operatorMore(TimeSpan t1, TimeSpan t2) {
        return t1.ticks > t2.ticks;
    }

    public static boolean operatorMoreEqual(TimeSpan t1, TimeSpan t2) {
        return t1.ticks >= t2.ticks;
    }
}

