/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class ArrayAssociation
extends Association {
    private final ArrayCreation m_arrayCreation;

    public ArrayAssociation(ArrayCreation arrayCreation) {
        this.m_arrayCreation = arrayCreation;
    }

    public ArrayCreation getCreation() {
        return this.m_arrayCreation;
    }

    @Override
    public Statement getStatement() {
        return AstNodeUtils.getEnclosingStatement((ASTNode)this.m_arrayCreation);
    }

    @Override
    public String getSource() {
        return this.m_editor.getSource((ASTNode)this.m_arrayCreation);
    }

    @Override
    public boolean remove() throws Exception {
        ArrayInitializer initializer = this.m_arrayCreation.getInitializer();
        ArrayList expressionsToRemove = Lists.newArrayList();
        List expressions = initializer.expressions();
        for (Expression expression : expressions) {
            if (!this.m_javaInfo.isRepresentedBy((ASTNode)expression)) continue;
            expressionsToRemove.add(expression);
        }
        for (Expression expression : expressionsToRemove) {
            int elementIndex = initializer.expressions().indexOf(expression);
            this.m_editor.removeArrayElement(initializer, elementIndex);
        }
        return super.remove();
    }
}

