/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class SystemPerspectiveHelpers {
    public static String RSE_PERSP_ID = "org.eclipse.rse.ui.view.SystemPerspective";

    public static boolean openRSEPerspective() {
        return SystemPerspectiveHelpers.openInNewPage(RSE_PERSP_ID);
    }

    public static boolean isRSEPerspectiveActive() {
        IPerspectiveDescriptor activePersp = SystemPerspectiveHelpers.getActivePerspective();
        return activePersp != null && activePersp.getId().equals(RSE_PERSP_ID);
    }

    public static boolean openInNewPage(String perspID) {
        boolean ok = false;
        IPerspectiveDescriptor persp = SystemPerspectiveHelpers.getActivePerspective();
        if (persp == null) {
            return ok;
        }
        if (persp.getId().equals(perspID)) {
            return true;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            persp = pages[i].getPerspective();
            if (persp != null && persp.getId().equals(perspID)) {
                window.setActivePage(pages[i]);
                return true;
            }
            ++i;
        }
        try {
            window.getWorkbench().showPerspective(perspID, window);
            ok = true;
        }
        catch (WorkbenchException e) {
            SystemBasePlugin.logError("Error opening perspective " + perspID, e);
        }
        return ok;
    }

    public static IPerspectiveDescriptor getActivePerspective() {
        IWorkbenchPage page;
        IWorkbenchWindow window = SystemPerspectiveHelpers.getActiveWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getPerspective();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IViewPart findView(String viewID) {
        IWorkbenchPage page;
        IViewPart viewPart = null;
        IWorkbenchWindow window = SystemPerspectiveHelpers.getActiveWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            viewPart = page.findView(viewID);
        }
        return viewPart;
    }

    public static SystemView findRSEView() {
        IViewPart viewPart = SystemPerspectiveHelpers.findView("org.eclipse.rse.ui.view.systemView");
        if (viewPart != null && viewPart instanceof SystemViewPart) {
            return ((SystemViewPart)viewPart).getSystemView();
        }
        return null;
    }

    public static IViewPart showView(String viewID) {
        IWorkbenchPage page;
        IViewPart viewPart = null;
        IWorkbenchWindow window = SystemPerspectiveHelpers.getActiveWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                viewPart = page.findView(viewID);
                if (viewPart != null) {
                    page.bringToTop((IWorkbenchPart)viewPart);
                } else {
                    viewPart = page.showView(viewID);
                }
            }
            catch (PartInitException pie) {
                SystemBasePlugin.logError("Error opening view " + viewID, pie);
            }
        }
        return viewPart;
    }
}

