/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorServiceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.services.dstore.files.DStoreFileService;
import org.eclipse.rse.internal.services.dstore.search.DStoreSearchService;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreFileAdapter;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreFileSubSystemSearchResultConfiguration;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreLanguageUtilityFactory;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;

public class DStoreFileSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    protected boolean _isWindows = false;
    protected IHostFileToRemoteFileAdapter _hostFileAdapter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DStoreFileSubSystemConfiguration() {
        this.setIsUnixStyle(!this._isWindows);
    }

    public boolean isFactoryFor(Class subSystemType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean isFor = clazz.equals(subSystemType);
        return isFor;
    }

    public boolean supportsArchiveManagement() {
        return true;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        DStoreConnectorService connectorService = (DStoreConnectorService)this.getConnectorService(host);
        FileServiceSubSystem subsys = new FileServiceSubSystem(host, (IConnectorService)connectorService, this.getFileService(host), this.getHostFileAdapter(), this.getSearchService(host));
        return subsys;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return true;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        DStoreConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public IConnectorService getConnectorService(IHost host) {
        return DStoreConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public IFileService createFileService(IHost host) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        DStoreConnectorService connectorService = (DStoreConnectorService)this.getConnectorService(host);
        final DStoreFileService service = new DStoreFileService((IDataStoreProvider)connectorService, (ISystemFileTypes)RemoteFileUtility.getSystemFileTransferModeRegistry());
        service.setIsUnixStyle(this.isUnixStyle());
        int dvalue = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size") * 1024;
        if (dvalue == 0) {
            dvalue = 10240;
        }
        service.setBufferDownloadSize(dvalue);
        int uvalue = store.getInt("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size") * 1024;
        if (uvalue == 0) {
            uvalue = 10240;
        }
        service.setBufferUploadSize(uvalue);
        Preferences.IPropertyChangeListener preferenceListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String propertyName = event.getProperty();
                if (propertyName.equals("org.eclipse.rse.subsystems.files.core.preferences.download.buffer.size")) {
                    int value = Integer.parseInt((String)event.getNewValue());
                    service.setBufferDownloadSize(value);
                } else if (propertyName.equals("org.eclipse.rse.subsystems.files.core.preferences.upload.buffer.size")) {
                    int value = Integer.parseInt((String)event.getNewValue());
                    service.setBufferDownloadSize(value);
                }
            }
        };
        Preferences pstore = RSEUIPlugin.getDefault().getPluginPreferences();
        pstore.addPropertyChangeListener(preferenceListener);
        return service;
    }

    public ISearchService createSearchService(IHost host) {
        DStoreConnectorService connectorService = (DStoreConnectorService)this.getConnectorService(host);
        return new DStoreSearchService((IDataStoreProvider)connectorService);
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        if (this._hostFileAdapter == null) {
            this._hostFileAdapter = new DStoreFileAdapter();
        }
        return this._hostFileAdapter;
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost host, IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        DStoreFileSubSystemSearchResultConfiguration config = new DStoreFileSubSystemSearchResultConfiguration(resultSet, searchTarget, searchString, this.getSearchService(host), this.getHostFileAdapter());
        resultSet.addSearchConfiguration((IHostSearchResultConfiguration)config);
        return config;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem ss) {
        return DStoreLanguageUtilityFactory.getInstance(ss);
    }

    public Class getServiceImplType() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.dstore.IDStoreService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

