/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.ui.actions.ExtractConstantAction;
import org.eclipse.wst.jsdt.ui.actions.ExtractMethodAction;
import org.eclipse.wst.jsdt.ui.actions.ExtractTempAction;
import org.eclipse.wst.jsdt.ui.actions.InlineAction;
import org.eclipse.wst.jsdt.ui.actions.IntroduceParameterAction;
import org.eclipse.wst.jsdt.ui.actions.ModifyParametersAction;
import org.eclipse.wst.jsdt.ui.actions.MoveAction;
import org.eclipse.wst.jsdt.ui.actions.RenameAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.eclipse.wst.jsdt.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.eclipse.wst.jsdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private static final String GROUP_REORG2 = "reorgGroup2";
    private static final String GROUP_TYPE2 = "typeGroup2";
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private String fGroupName = "group.reorganize";
    private boolean fBinary = false;
    private SelectionDispatchAction fMoveAction;
    private SelectionDispatchAction fRenameAction;
    private SelectionDispatchAction fModifyParametersAction;
    private SelectionDispatchAction fPullUpAction;
    private SelectionDispatchAction fPushDownAction;
    private SelectionDispatchAction fExtractSupertypeAction;
    private SelectionDispatchAction fUseSupertypeAction;
    private SelectionDispatchAction fInlineAction;
    private SelectionDispatchAction fIntroduceIndirectionAction;
    private SelectionDispatchAction fExtractMethodAction;
    private SelectionDispatchAction fExtractTempAction;
    private SelectionDispatchAction fExtractConstantAction;
    private SelectionDispatchAction fIntroduceParameterAction;
    private SelectionDispatchAction fIntroduceFactoryAction;
    private SelectionDispatchAction fConvertLocalToFieldAction;
    private SelectionDispatchAction fSelfEncapsulateField;
    private UndoRedoActionGroup fUndoRedoActionGroup;
    private final List fActions = new ArrayList();
    private static final String QUICK_MENU_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.refactor.quickMenu";
    private JDTQuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private Action fNoActionAvailable = new NoActionAvailable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext workspaceContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)part.getViewSite(), workspaceContext, true);
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public RefactorActionGroup(JavaEditor editor, String groupName, boolean binary) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.fBinary = binary;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        if (!this.fBinary) {
            this.fRenameAction = new RenameAction(editor);
            this.initAction(this.fRenameAction, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.rename.element");
            editor.setAction("RenameElement", (IAction)this.fRenameAction);
            this.fMoveAction = new MoveAction(editor);
            this.initAction(this.fMoveAction, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.move.element");
            editor.setAction("MoveElement", (IAction)this.fMoveAction);
            this.fModifyParametersAction = new ModifyParametersAction(editor);
            this.initAction(this.fModifyParametersAction, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.modify.method.parameters");
            editor.setAction("ModifyParameters", (IAction)this.fModifyParametersAction);
            this.fExtractMethodAction = new ExtractMethodAction(editor);
            this.initUpdatingAction(this.fExtractMethodAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.method");
            editor.setAction("ExtractMethod", (IAction)this.fExtractMethodAction);
            this.fExtractTempAction = new ExtractTempAction(editor);
            this.initUpdatingAction(this.fExtractTempAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.local.variable");
            editor.setAction("ExtractLocalVariable", (IAction)this.fExtractTempAction);
            this.fExtractConstantAction = new ExtractConstantAction(editor);
            this.initUpdatingAction(this.fExtractConstantAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.extract.constant");
            editor.setAction("ExtractConstant", (IAction)this.fExtractConstantAction);
            this.fIntroduceParameterAction = new IntroduceParameterAction(editor);
            this.initUpdatingAction(this.fIntroduceParameterAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.introduce.parameter");
            editor.setAction("IntroduceParameter", (IAction)this.fIntroduceParameterAction);
        }
        this.fInlineAction = new InlineAction(editor);
        this.initAction(this.fInlineAction, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.inline");
        editor.setAction("Inline", (IAction)this.fInlineAction);
        this.installQuickAccessAction();
        stats.endRun();
    }

    private RefactorActionGroup(IWorkbenchSite site) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        if (!this.fBinary) {
            this.fMoveAction = new MoveAction(site);
            this.initUpdatingAction(this.fMoveAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.move.element");
            this.fRenameAction = new RenameAction(site);
            this.initUpdatingAction(this.fRenameAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.rename.element");
            this.fModifyParametersAction = new ModifyParametersAction(this.fSite);
            this.initUpdatingAction(this.fModifyParametersAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.modify.method.parameters");
        }
        this.fInlineAction = new InlineAction(this.fSite);
        this.initUpdatingAction(this.fInlineAction, provider, selection, "org.eclipse.wst.jsdt.ui.edit.text.java.inline");
        this.installQuickAccessAction();
        stats.endRun();
    }

    private void installQuickAccessAction() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)this.fSite.getService((Class)clazz);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(this.fEditor);
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    private void initAction(SelectionDispatchAction action, ISelection selection, String actionDefinitionId) {
        this.initUpdatingAction(action, null, selection, actionDefinitionId);
    }

    private void initUpdatingAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        action.update(selection);
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.fActions.add(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (!this.fBinary) {
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Move", (IAction)this.fMoveAction);
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Rename", (IAction)this.fRenameAction);
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ModifyParameters", (IAction)this.fModifyParametersAction);
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExtractTemp", (IAction)this.fExtractTempAction);
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExtractMethod", (IAction)this.fExtractMethodAction);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.fillActionBars(actionBars);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (!this.fBinary) {
            this.disposeAction(this.fMoveAction, provider);
            this.disposeAction(this.fRenameAction, provider);
            this.disposeAction(this.fExtractTempAction, provider);
            this.disposeAction(this.fIntroduceParameterAction, provider);
            this.disposeAction(this.fExtractMethodAction, provider);
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = ActionMessages.RefactorMenu_label;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager refactorSubmenu = new MenuManager(menuText, MENU_ID);
        if (this.fEditor != null) {
            IJavaScriptElement element = SelectionConverter.getInput(this.fEditor);
            if (element != null && ActionUtil.isOnBuildPath(element)) {
                refactorSubmenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        RefactorActionGroup.this.refactorMenuShown(manager);
                    }
                });
                refactorSubmenu.add((IAction)this.fNoActionAvailable);
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update(selection);
            }
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fMoveAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        added += this.addAction(refactorSubmenu, (IAction)this.fModifyParametersAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractMethodAction);
        added += this.addAction(refactorSubmenu, (IAction)this.fExtractTempAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING2));
        return added += this.addAction(refactorSubmenu, (IAction)this.fIntroduceParameterAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        JavaTextSelection javaSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)javaSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)textSelection);
        }
    }

    private IJavaScriptElement getEditorInput() {
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            IClassFileEditorInput extended = (IClassFileEditorInput)input;
            return extended.getClassFile();
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private IDocument getDocument() {
        return JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.fEditor != null) {
            IJavaScriptElement element = SelectionConverter.getInput(this.fEditor);
            if (element == null || !ActionUtil.isOnBuildPath(element)) {
                menu.add((IAction)this.fNoActionAvailable);
                return;
            }
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            JavaTextSelection javaSelection = new JavaTextSelection(this.getEditorInput(), this.getDocument(), textSelection.getOffset(), textSelection.getLength());
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)javaSelection);
            }
            this.fillRefactorMenu(menu);
            iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update((ISelection)textSelection);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                ((SelectionDispatchAction)((Object)iter.next())).update(selection);
            }
            this.fillRefactorMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringMessages.RefactorActionGroup_no_refactoring_available);
        }
    }

    private class RefactorQuickAccessAction
    extends JDTQuickMenuAction {
        public RefactorQuickAccessAction(JavaEditor editor) {
            super(editor, RefactorActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            RefactorActionGroup.this.fillQuickMenu(menu);
        }
    }
}

