/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaScriptProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDLIB = 0;
    private final int IDX_ADDFOL = 1;
    private final int IDX_EDIT = 3;
    private final int IDX_REMOVE = 4;

    public LibrariesWorkbookPage(CheckedListDialogField classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
    }

    public void init(IJavaScriptProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
    }

    private void updateLibrariesList() {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaScriptPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 1: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 3: {
                this.editEntry();
                return;
            }
            case 4: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            if (index == 0) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    public void addElement(CPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashMap<CPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<CPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            CPListElement listElem;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn()) {
                    IAccessRule[] value = null;
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.setValue(value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof CPListElement) {
                    CPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            } else if (elem instanceof CPListElement && (listElem = (CPListElement)elem).getEntryKind() == 5) {
                JsGlobalScopeContainerInitializer init = listElem.getContainerInitializer();
                init.removeFromProject(this.fCurrJProject);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        Iterator iter = containerEntriesToUpdate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            CPListElement curr = (CPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            IIncludePathEntry changedEntry = curr.getClasspathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.isNonModifiable()) {
                    return false;
                }
                if (attrib.isBuiltIn()) {
                    if (attrib.getParent().isInContainer("org.eclipse.wst.jsdt.launching.JRE_CONTAINER") && "accessrules".equals(attrib.getKey())) {
                        return false;
                    }
                    if (attrib.getKey().equals("accessrules")) {
                        return ((IAccessRule[])attrib.getValue()).length > 0;
                    }
                    if (attrib.getValue() == null) {
                        return false;
                    }
                } else if (!this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else if (elem instanceof CPListElement) {
                CPListElement curr = (CPListElement)elem;
                if (curr.getEntryKind() == 5) {
                    return !curr.isInNonModifiableContainer();
                }
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null);
            int res = dialog.open();
            if (res == 0 || res == 10) {
                selElement.setAttribute("accessrules", dialog.getAccessRules());
                String[] changedAttributes = new String[]{"accessrules"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fLibrariesList.refresh(elem);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
                if (res == 10) {
                    dialog.performPageSwitch(this.fPageContainer);
                }
            }
        } else if (this.editCustomAttribute(this.getShell(), elem)) {
            String[] changedAttributes = new String[]{key};
            this.attributeUpdated(selElement, changedAttributes);
            this.fLibrariesList.refresh(elem);
            this.fClassPathList.dialogFieldChanged();
            this.updateEnabledState();
        }
    }

    private void attributeUpdated(CPListElement selElement, String[] changedAttributes) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof CPListElement) {
            IIncludePathEntry updatedEntry = selElement.getClasspathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IIncludePathEntry newEntry, final String[] changedAttributes, final IJavaScriptProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, newEntry, changedAttributes, jproject, containerPath, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource.getType() != 2 || !resource.exists()) break;
                res = this.openClassFolderDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            curr.setAttributesFromExisting(elem);
            this.fLibrariesList.replaceElement(elem, curr);
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(3, this.canEdit(selElements));
        this.fLibrariesList.enableButton(4, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(0, noAttributes);
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement curr = (CPListElement)elem;
            if (curr.getEntryKind() == 5) {
                return !curr.isInNonModifiableContainer();
            }
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (!attrib.isBuiltIn()) {
                return this.canEditCustomAttribute(attrib);
            }
            return true;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IIncludePathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPListElement(this.fCurrJProject, created[i].getEntryKind(), created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IIncludePathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existing.getClasspathEntry(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, created.getEntryKind(), created.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IIncludePathEntry[] getRawClasspath() {
        IIncludePathEntry[] currEntries = new IIncludePathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren();
            }
            if (element instanceof CPListElementAttribute && "accessrules".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

