/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;

public class LogicalPackage
extends PlatformObject {
    private Set fPackages;
    private String fName;
    private IJavaScriptProject fJavaProject;

    public LogicalPackage(IPackageFragment fragment) {
        Assert.isNotNull((Object)fragment);
        this.fPackages = new HashSet();
        this.fJavaProject = fragment.getJavaScriptProject();
        Assert.isNotNull((Object)this.fJavaProject);
        this.add(fragment);
        this.fName = fragment.getElementName();
    }

    public IJavaScriptProject getJavaProject() {
        return this.fJavaProject;
    }

    public IPackageFragment[] getFragments() {
        return this.fPackages.toArray(new IPackageFragment[this.fPackages.size()]);
    }

    public void add(IPackageFragment fragment) {
        Assert.isTrue((fragment != null && this.fJavaProject.equals(fragment.getJavaScriptProject()) ? 1 : 0) != 0);
        this.fPackages.add(fragment);
    }

    public void remove(IPackageFragment fragment) {
        this.fPackages.remove(fragment);
    }

    public boolean contains(IPackageFragment fragment) {
        return this.fPackages.contains(fragment);
    }

    public String getElementName() {
        return this.fName;
    }

    public int size() {
        return this.fPackages.size();
    }

    public boolean belongs(IPackageFragment fragment) {
        if (fragment == null) {
            return false;
        }
        if (this.fJavaProject.equals(fragment.getJavaScriptProject())) {
            return this.fName.equals(fragment.getElementName());
        }
        return false;
    }

    public boolean hasSubpackages() throws JavaScriptModelException {
        Iterator iter = this.fPackages.iterator();
        while (iter.hasNext()) {
            IPackageFragment pack = (IPackageFragment)iter.next();
            if (!pack.hasSubpackages()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.fName.length() == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPackage)) {
            return false;
        }
        LogicalPackage lp = (LogicalPackage)((Object)o);
        if (!this.fJavaProject.equals(lp.getJavaProject())) {
            return false;
        }
        IPackageFragment[] fragments = lp.getFragments();
        if (fragments.length != this.getFragments().length) {
            return false;
        }
        int i = 0;
        while (i < fragments.length) {
            IPackageFragment fragment = fragments[i];
            if (!this.fPackages.contains(fragment)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        IPackageFragment[] fragments = this.getFragments();
        return this.fJavaProject.hashCode() + this.getHash(fragments, fragments.length - 1);
    }

    private int getHash(IPackageFragment[] fragments, int index) {
        if (index <= 0) {
            return fragments[0].hashCode() * 17;
        }
        return fragments[index].hashCode() * 17 + this.getHash(fragments, index - 1);
    }
}

