/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public abstract class AbstractMethodCompletionProposal
extends LinkedCorrectionProposal {
    private ASTNode fNode;
    private ITypeBinding fSenderBinding;

    public AbstractMethodCompletionProposal(String label, IJavaScriptUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fNode = invocationNode;
        this.fSenderBinding = binding;
    }

    protected ASTNode getInvocationNode() {
        return this.fNode;
    }

    protected ITypeBinding getSenderBinding() {
        return this.fSenderBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        JavaScriptUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            isInDifferentCU = false;
            newTypeDecl = typeDecl;
        } else {
            isInDifferentCU = true;
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            FunctionDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List members = (List)newTypeDecl.getStructuralProperty((StructuralPropertyDescriptor)property);
            int insertIndex = this.isConstructor() ? this.findConstructorInsertIndex(members) : (!isInDifferentCU ? this.findMethodInsertIndex(members, this.fNode.getStartPosition()) : members.size());
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt((ASTNode)newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private FunctionDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        String string;
        AST ast = targetTypeDecl.getAST();
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.setConstructor(this.isConstructor());
        this.addNewModifiers(rewrite, targetTypeDecl, decl.modifiers());
        ArrayList<String> takenNames = new ArrayList<String>();
        this.addNewTypeParameters(rewrite, takenNames, decl.typeParameters());
        decl.setName(newNameNode);
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            takenNames.add(declaredFields[i].getName());
            ++i;
        }
        String bodyStatement = "";
        if (!this.isConstructor()) {
            Type returnType = this.getNewMethodType(rewrite);
            if (returnType == null) {
                decl.setReturnType2((Type)ast.newPrimitiveType(PrimitiveType.VOID));
            } else {
                decl.setReturnType2(returnType);
            }
            if (!this.fSenderBinding.isInterface() && returnType != null) {
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTNodeFactory.newDefaultExpression(ast, returnType, 0));
                bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaScriptProject().getOptions(true));
            }
        }
        this.addNewParameters(rewrite, takenNames, decl.parameters());
        this.addNewExceptions(rewrite, decl.thrownExceptions());
        Block body = null;
        if (!this.fSenderBinding.isInterface()) {
            body = ast.newBlock();
            String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), this.fSenderBinding.getName(), newNameNode.getIdentifier(), this.isConstructor(), bodyStatement, String.valueOf('\n'));
            if (placeHolder != null) {
                ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        decl.setBody(body);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaScriptProject());
        if (settings.createComments && !this.fSenderBinding.isAnonymous() && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), this.fSenderBinding.getName(), decl, null, String.valueOf('\n'))) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private int findMethodInsertIndex(List decls, int currPos) {
        int nDecls = decls.size();
        int i = 0;
        while (i < nDecls) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FunctionDeclaration && currPos < curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            ++i;
        }
        return nDecls;
    }

    private int findConstructorInsertIndex(List decls) {
        int nDecls = decls.size();
        int lastMethod = 0;
        int i = nDecls - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FunctionDeclaration) {
                if (((FunctionDeclaration)curr).isConstructor()) {
                    return i + 1;
                }
                lastMethod = i;
            }
            --i;
        }
        return lastMethod;
    }

    protected abstract boolean isConstructor();

    protected abstract void addNewModifiers(ASTRewrite var1, ASTNode var2, List var3);

    protected abstract void addNewTypeParameters(ASTRewrite var1, List var2, List var3) throws CoreException;

    protected abstract void addNewParameters(ASTRewrite var1, List var2, List var3) throws CoreException;

    protected abstract void addNewExceptions(ASTRewrite var1, List var2) throws CoreException;

    protected abstract SimpleName getNewName(ASTRewrite var1);

    protected abstract Type getNewMethodType(ASTRewrite var1) throws CoreException;
}

