/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.ui.internal.listeners.SWTCollectionChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBoxModelAdapter<E> {
    protected final ListValueModel<E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final CollectionValueModel<E> selectedItemsHolder;
    protected final CollectionChangeListener selectedItemsChangeListener;
    protected StringConverter<E> stringConverter;
    protected final List listBox;
    protected final SelectionListener listBoxSelectionListener;
    protected SelectionChangeListener<E>[] selectionChangeListeners;
    protected DoubleClickListener<E>[] doubleClickListeners;
    protected final DisposeListener listBoxDisposeListener;

    public static <T> ListBoxModelAdapter<T> adapt(ListValueModel<T> listHolder, CollectionValueModel<T> selectedItemsHolder, List listBox) {
        return ListBoxModelAdapter.adapt(listHolder, selectedItemsHolder, listBox, StringConverter.Default.instance());
    }

    public static <T> ListBoxModelAdapter<T> adapt(ListValueModel<T> listHolder, CollectionValueModel<T> selectedItemsHolder, List listBox, StringConverter<T> stringConverter) {
        return new ListBoxModelAdapter<T>(listHolder, selectedItemsHolder, listBox, stringConverter);
    }

    public static <T> ListBoxModelAdapter<T> adapt(ListValueModel<T> listHolder, PropertyValueModel<T> selectedItemHolder, List listBox) {
        return ListBoxModelAdapter.adapt(listHolder, selectedItemHolder, listBox, StringConverter.Default.instance());
    }

    public static <T> ListBoxModelAdapter<T> adapt(ListValueModel<T> listHolder, PropertyValueModel<T> selectedItemHolder, List listBox, StringConverter<T> stringConverter) {
        return new ListBoxModelAdapter<T>(listHolder, new PropertyCollectionValueModelAdapter(selectedItemHolder), listBox, stringConverter);
    }

    protected ListBoxModelAdapter(ListValueModel<E> listHolder, CollectionValueModel<E> selectedItemsHolder, List listBox, StringConverter<E> stringConverter) {
        if (listHolder == null || selectedItemsHolder == null || listBox == null || stringConverter == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.selectedItemsHolder = selectedItemsHolder;
        this.listBox = listBox;
        this.stringConverter = stringConverter;
        this.listChangeListener = this.buildListChangeListener();
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.selectedItemsChangeListener = this.buildSelectedItemsChangeListener();
        this.selectedItemsHolder.addCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.listBoxSelectionListener = this.buildListBoxSelectionListener();
        this.listBox.addSelectionListener(this.listBoxSelectionListener);
        this.selectionChangeListeners = this.buildSelectionChangeListeners();
        this.doubleClickListeners = this.buildDoubleClickListeners();
        this.listBoxDisposeListener = this.buildListBoxDisposeListener();
        this.listBox.addDisposeListener(this.listBoxDisposeListener);
        this.synchronizeListBox();
    }

    protected ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ListBoxModelAdapter.this.listItemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                ListBoxModelAdapter.this.listItemsRemoved(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                ListBoxModelAdapter.this.listItemsMoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                ListBoxModelAdapter.this.listItemsReplaced(event);
            }

            public void listCleared(ListChangeEvent event) {
                ListBoxModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListBoxModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener() {
        return new SWTCollectionChangeListenerWrapper(this.buildSelectedItemsChangeListener_());
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener_() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                ListBoxModelAdapter.this.selectedItemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                ListBoxModelAdapter.this.selectedItemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                ListBoxModelAdapter.this.selectedItemsCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                ListBoxModelAdapter.this.selectedItemsChanged(event);
            }

            public String toString() {
                return "selected items listener";
            }
        };
    }

    protected SelectionListener buildListBoxSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ListBoxModelAdapter.this.listBoxSelectionChanged(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ListBoxModelAdapter.this.listBoxDoubleClicked(event);
            }

            public String toString() {
                return "list box selection listener";
            }
        };
    }

    protected DoubleClickListener<E>[] buildDoubleClickListeners() {
        return new DoubleClickListener[0];
    }

    protected SelectionChangeListener<E>[] buildSelectionChangeListeners() {
        return new SelectionChangeListener[0];
    }

    protected DisposeListener buildListBoxDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ListBoxModelAdapter.this.listBoxDisposed(event);
            }

            public String toString() {
                return "list box dispose listener";
            }
        };
    }

    protected void synchronizeListBox() {
        this.synchronizeListBoxItems();
        this.synchronizeListBoxSelection();
    }

    public void setStringConverter(StringConverter<E> stringConverter) {
        if (stringConverter == null) {
            throw new NullPointerException();
        }
        this.stringConverter = stringConverter;
        this.synchronizeListBox();
    }

    protected String convert(E item) {
        return this.stringConverter.convertToString(item);
    }

    protected void synchronizeListBoxItems() {
        if (this.listBox.isDisposed()) {
            return;
        }
        int len = this.listHolder.size();
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = this.convert(this.listHolder.get(i));
            ++i;
        }
        this.listBox.setItems(items);
    }

    protected void listItemsAdded(ListChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        int i = event.getIndex();
        ListIterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            this.listBox.add(this.convert(stream.next()), i++);
        }
    }

    protected void listItemsRemoved(ListChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        this.listBox.remove(event.getIndex(), event.getIndex() + event.itemsSize() - 1);
    }

    protected void listItemsMoved(ListChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        int target = event.getTargetIndex();
        int source = event.getSourceIndex();
        int len = event.getMoveLength();
        int loStart = Math.min(target, source);
        int hiStart = Math.max(target, source);
        Object[] subArray = (String[])CollectionTools.subArray((Object[])this.listBox.getItems(), (int)loStart, (int)(hiStart + len - loStart));
        subArray = (String[])CollectionTools.move((Object[])subArray, (int)(target - loStart), (int)(source - loStart), (int)len);
        int i = 0;
        while (i < subArray.length) {
            this.listBox.setItem(loStart + i, (String)subArray[i]);
            ++i;
        }
    }

    protected void listItemsReplaced(ListChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        int i = event.getIndex();
        ListIterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            this.listBox.setItem(i++, this.convert(stream.next()));
        }
    }

    protected void listCleared(ListChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        this.listBox.removeAll();
    }

    protected void listChanged(ListChangeEvent event) {
        this.synchronizeListBoxItems();
    }

    protected ListIterator<E> items(ListChangeEvent event) {
        return event.items();
    }

    protected int indexOf(E item) {
        int len = this.listHolder.size();
        int i = 0;
        while (i < len) {
            if (this.listHolder.get(i) == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void synchronizeListBoxSelection() {
        if (this.listBox.isDisposed()) {
            return;
        }
        int[] indices = new int[this.selectedItemsHolder.size()];
        int i = 0;
        Iterator stream = this.selectedItemsHolder.iterator();
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.listBox.deselectAll();
        this.listBox.select(indices);
    }

    protected void selectedItemsAdded(CollectionChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        int[] indices = new int[event.itemsSize()];
        int i = 0;
        Iterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.listBox.select(indices);
    }

    protected void selectedItemsRemoved(CollectionChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        int[] indices = new int[event.itemsSize()];
        int i = 0;
        Iterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.listBox.deselect(indices);
    }

    protected void selectedItemsCleared(CollectionChangeEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        this.listBox.deselectAll();
    }

    protected void selectedItemsChanged(CollectionChangeEvent event) {
        this.synchronizeListBoxSelection();
    }

    protected Iterator<E> items(CollectionChangeEvent event) {
        return event.items();
    }

    protected void listBoxSelectionChanged(SelectionEvent event) {
        if (this.selectionChangeListeners.length > 0) {
            SelectionChangeEvent<E> scEvent = new SelectionChangeEvent<E>(this, this.selectedItems());
            SelectionChangeListener<E>[] selectionChangeListenerArray = this.selectionChangeListeners;
            int n = this.selectionChangeListeners.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionChangeListener<E> selectionChangeListener = selectionChangeListenerArray[n2];
                selectionChangeListener.selectionChanged(scEvent);
                ++n2;
            }
        }
    }

    protected Collection<E> selectedItems() {
        if (this.listBox.isDisposed()) {
            return Collections.emptySet();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>(this.listBox.getSelectionCount());
        int[] nArray = this.listBox.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectionIndex = nArray[n2];
            selectedItems.add(this.listHolder.get(selectionIndex));
            ++n2;
        }
        return selectedItems;
    }

    protected void listBoxDoubleClicked(SelectionEvent event) {
        if (this.listBox.isDisposed()) {
            return;
        }
        if (this.doubleClickListeners.length > 0) {
            Object selection = this.listHolder.get(this.listBox.getSelectionIndex());
            DoubleClickEvent<Object> dcEvent = new DoubleClickEvent<Object>(this, selection);
            DoubleClickListener<E>[] doubleClickListenerArray = this.doubleClickListeners;
            int n = this.doubleClickListeners.length;
            int n2 = 0;
            while (n2 < n) {
                DoubleClickListener<Object> doubleClickListener = doubleClickListenerArray[n2];
                doubleClickListener.doubleClick(dcEvent);
                ++n2;
            }
        }
    }

    protected void listBoxDisposed(DisposeEvent event) {
        this.listBox.removeDisposeListener(this.listBoxDisposeListener);
        this.listBox.removeSelectionListener(this.listBoxSelectionListener);
        this.selectedItemsHolder.removeCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.listHolder);
    }

    public void addDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListeners = (DoubleClickListener[])CollectionTools.add((Object[])this.doubleClickListeners, listener);
    }

    public void removeDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListeners = (DoubleClickListener[])CollectionTools.remove((Object[])this.doubleClickListeners, listener);
    }

    public void addSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListeners = (SelectionChangeListener[])CollectionTools.add((Object[])this.selectionChangeListeners, listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListeners = (SelectionChangeListener[])CollectionTools.remove((Object[])this.selectionChangeListeners, listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleClickEvent<E>
    extends EventObject {
        private final E selection;
        private static final long serialVersionUID = 1L;

        protected DoubleClickEvent(ListBoxModelAdapter<E> source, E selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public ListBoxModelAdapter<E> getSource() {
            return (ListBoxModelAdapter)super.getSource();
        }

        public E selection() {
            return this.selection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleClickListener<E> {
        public void doubleClick(DoubleClickEvent<E> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectionChangeEvent<E>
    extends EventObject {
        private final Collection<E> selection;
        private static final long serialVersionUID = 1L;

        protected SelectionChangeEvent(ListBoxModelAdapter<E> source, Collection<E> selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public ListBoxModelAdapter<E> getSource() {
            return (ListBoxModelAdapter)super.getSource();
        }

        public Iterator<E> selection() {
            return this.selection.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectionChangeListener<E> {
        public void selectionChanged(SelectionChangeEvent<E> var1);
    }
}

