/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticImpl;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticSeverity;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.JAXPPool;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WSDLParser
extends DefaultHandler
implements LexicalHandler {
    private static final String END_COLUMN = "endColumn";
    private static final String END_LINE = "endLine";
    private static final String START_COLUMN = "startColumn";
    private static final String START_LINE = "startLine";
    protected static final Map userDataMap = Collections.synchronizedMap(new WeakHashMap());
    protected int column;
    List diagnostics = new ArrayList();
    protected Document document;
    protected Element element;
    protected String encoding;
    protected boolean inSchema;
    protected int line;
    protected Locator locator;
    protected SAXParser saxParser;
    protected Stack stack = new Stack();
    protected JAXPPool jaxpPool;

    private static LocationMap getLocationMap(Node node) {
        LocationMap result = (LocationMap)userDataMap.get(node);
        if (result == null) {
            result = new LocationMap();
            userDataMap.put(node, result);
        }
        return result;
    }

    public static int getEndColumn(Node node) {
        int result = WSDLParser.getLocationMap(node).getEndColumn();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static int getEndLine(Node node) {
        int result = WSDLParser.getLocationMap(node).getEndLine();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static int getStartColumn(Node node) {
        int result = WSDLParser.getLocationMap(node).getStartColumn();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static int getStartLine(Node node) {
        int result = WSDLParser.getLocationMap(node).getStartLine();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static Map getUserData(Node node) {
        return WSDLParser.getLocationMap(node);
    }

    public WSDLParser() {
        this(Collections.EMPTY_MAP);
    }

    public WSDLParser(Map options) {
        JAXPConfiguration config = null;
        if (options != null) {
            this.jaxpPool = (JAXPPool)options.get("WSDL_JAXP_POOL");
            config = (JAXPConfiguration)options.get("WSDL_JAXP_CONFIG");
        }
        try {
            this.saxParser = this.jaxpPool == null ? (config != null ? config.createSAXParser((LexicalHandler)this) : new DefaultJAXPConfiguration().createSAXParser((LexicalHandler)this)) : this.jaxpPool.getSAXParser((LexicalHandler)this);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
        catch (ParserConfigurationException exception) {
            this.fatalError(exception);
        }
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        Text textNode = this.document.createTextNode(new String(characters, start, length));
        this.element.appendChild(textNode);
        this.saveLocation();
    }

    public void comment(char[] characters, int start, int length) throws SAXException {
        Comment commentNode = this.document.createComment(new String(characters, start, length));
        if (this.element == null) {
            this.document.appendChild(commentNode);
        } else {
            this.element.appendChild(commentNode);
        }
        this.saveLocation();
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException exception) {
            WSDLPlugin.INSTANCE.log(exception);
            return null;
        }
    }

    public void endCDATA() {
    }

    public void endDocument() {
        this.element = null;
        this.saveLocation();
        this.locator = null;
    }

    public void endDTD() {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        if (this.inSchema) {
            Map userData = XSDParser.getUserData((Node)this.element);
            userData.put(END_LINE, new Integer(this.line));
            userData.put(END_COLUMN, new Integer(this.column));
        } else {
            LocationMap locationMap = WSDLParser.getLocationMap(this.element);
            locationMap.setEndLine(this.line);
            locationMap.setEndColumn(this.column);
        }
        if (this.isSchemaElement(uri, localName)) {
            this.inSchema = false;
        }
        this.element = (Element)this.stack.pop();
    }

    public void endEntity(String name) {
    }

    public void error(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.ERROR_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getMessage()}));
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }

    protected void fatalError(IOException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    public void fatalError(SAXException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    public void fatalError(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }

    public Collection getDiagnostics() {
        return this.diagnostics;
    }

    public Document getDocument() {
        return this.document;
    }

    private boolean isSchemaElement(String uri, String localName) {
        return uri.equals("http://www.w3.org/2001/XMLSchema") && localName.equals("schema");
    }

    /*
     * Exception decompiling
     */
    public void parse(InputSource inputSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 73->77)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void parse(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 80->84)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(target, data);
        if (this.stack.isEmpty()) {
            this.document.appendChild(processingInstruction);
        } else {
            this.element.appendChild(processingInstruction);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource inputSource;
        if ("-//W3C//DTD XMLSCHEMA 200102//EN".equalsIgnoreCase(publicId)) {
            inputSource = new InputSource(XSDPlugin.INSTANCE.getBaseURL() + "cache/www.w3.org/2001/XMLSchema.dtd");
            inputSource.setPublicId(publicId);
        } else if (systemId != null && systemId.startsWith("file://bundleentry:")) {
            inputSource = new InputSource(systemId.substring(7));
            inputSource.setPublicId(publicId);
        } else {
            try {
                inputSource = super.resolveEntity(publicId, systemId);
            }
            catch (IOException exception) {
                throw new SAXException(exception);
            }
        }
        return inputSource;
    }

    protected void saveLocation() {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
            if (this.column == -1) {
                this.column = 1;
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startCDATA() {
    }

    public void startDocument() {
        this.saveLocation();
        this.document = this.createDocument();
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.inSchema) {
            this.inSchema = this.isSchemaElement(uri, localName);
        }
        Element newElement = this.document.createElementNS(uri, qName);
        int index = 0;
        int count = attributes.getLength();
        while (index < count) {
            String attributeURI = attributes.getURI(index);
            String attributeQName = attributes.getQName(index);
            String attributeValue = attributes.getValue(index);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
            ++index;
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        if (this.inSchema) {
            Map userData = XSDParser.getUserData((Node)this.element);
            userData.put(START_LINE, new Integer(this.line));
            userData.put(START_COLUMN, new Integer(this.column));
        } else {
            LocationMap locationMap = WSDLParser.getLocationMap(this.element);
            locationMap.setStartLine(this.line);
            locationMap.setStartColumn(this.column);
        }
        this.saveLocation();
    }

    public void startEntity(String name) {
    }

    public void warning(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.WARNING_LITERAL);
        diagnostic.setMessage("DOM:" + exception.getMessage());
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }

    public String getEncoding() {
        if (this.locator != null) {
            try {
                Method getEncodingMethod = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (getEncodingMethod != null) {
                    this.encoding = (String)getEncodingMethod.invoke((Object)this.locator, new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        return this.encoding;
    }

    private static final class LocationMap
    extends AbstractMap {
        protected static final int UNSET = Integer.MAX_VALUE;
        protected Map delegateMap;
        private int startLine = Integer.MAX_VALUE;
        private int startColumn = Integer.MAX_VALUE;
        private int endLine = Integer.MAX_VALUE;
        private int endColumn = Integer.MAX_VALUE;

        private LocationMap() {
        }

        public Set entrySet() {
            return this.getDelegateMap().entrySet();
        }

        protected Map getDelegateMap() {
            if (this.delegateMap == null) {
                this.delegateMap = new HashMap();
                if (this.startLine != Integer.MAX_VALUE) {
                    this.delegateMap.put(WSDLParser.START_LINE, new Integer(this.startLine));
                }
                if (this.startColumn != Integer.MAX_VALUE) {
                    this.delegateMap.put(WSDLParser.START_COLUMN, new Integer(this.startColumn));
                }
                if (this.endLine != Integer.MAX_VALUE) {
                    this.delegateMap.put(WSDLParser.END_LINE, new Integer(this.endLine));
                }
                if (this.endColumn != Integer.MAX_VALUE) {
                    this.delegateMap.put(WSDLParser.END_COLUMN, new Integer(this.endColumn));
                }
            }
            return this.delegateMap;
        }

        protected int objectToInt(Object value) {
            return value == null ? Integer.MAX_VALUE : (Integer)value;
        }

        protected Object intToObject(int value) {
            return value == Integer.MAX_VALUE ? null : new Integer(value);
        }

        public Object put(Object key, Object value) {
            Object result;
            if (this.delegateMap == null) {
                if (WSDLParser.START_LINE.equals(key)) {
                    result = this.intToObject(this.startLine);
                    this.startLine = this.objectToInt(value);
                } else if (WSDLParser.END_LINE.equals(key)) {
                    result = this.intToObject(this.endLine);
                    this.endLine = this.objectToInt(value);
                } else if (WSDLParser.START_COLUMN.equals(key)) {
                    result = this.intToObject(this.startColumn);
                    this.startColumn = this.objectToInt(value);
                } else if (WSDLParser.END_COLUMN.equals(key)) {
                    result = this.intToObject(this.endColumn);
                    this.endColumn = this.objectToInt(value);
                } else {
                    result = this.getDelegateMap().put(key, value);
                }
            } else {
                result = this.getDelegateMap().put(key, value);
            }
            return result;
        }

        public int getStartLine() {
            return this.delegateMap == null ? this.startLine : this.objectToInt(this.delegateMap.get(WSDLParser.START_LINE));
        }

        public void setStartLine(int startLine) {
            if (this.delegateMap == null) {
                this.startLine = startLine;
            } else {
                this.delegateMap.put(WSDLParser.START_LINE, new Integer(startLine));
            }
        }

        public int getStartColumn() {
            return this.delegateMap == null ? this.startColumn : this.objectToInt(this.delegateMap.get(WSDLParser.START_COLUMN));
        }

        public void setStartColumn(int startColumn) {
            if (this.delegateMap == null) {
                this.startColumn = startColumn;
            } else {
                this.delegateMap.put(WSDLParser.START_COLUMN, new Integer(startColumn));
            }
        }

        public int getEndLine() {
            return this.delegateMap == null ? this.endLine : this.objectToInt(this.delegateMap.get(WSDLParser.END_LINE));
        }

        public void setEndLine(int endLine) {
            if (this.delegateMap == null) {
                this.endLine = endLine;
            } else {
                this.delegateMap.put(WSDLParser.END_LINE, new Integer(endLine));
            }
        }

        public int getEndColumn() {
            return this.delegateMap == null ? this.endColumn : this.objectToInt(this.delegateMap.get(WSDLParser.END_COLUMN));
        }

        public void setEndColumn(int endColumn) {
            if (this.delegateMap == null) {
                this.endColumn = endColumn;
            } else {
                this.delegateMap.put(WSDLParser.END_COLUMN, new Integer(endColumn));
            }
        }
    }
}

