/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.code.ExtractMethodWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExtractMethodAction
extends SelectionDispatchAction {
    private final JavaEditor fEditor;

    public ExtractMethodAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.ExtractMethodAction_label);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.extract_method_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection.getLength() == 0 ? false : this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(RefactoringAvailabilityTester.isExtractMethodAvailable(selection));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        try {
            ExtractMethodRefactoring refactoring = new ExtractMethodRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection.getOffset(), selection.getLength());
            new RefactoringStarter().activate(refactoring, new ExtractMethodWizard(refactoring), this.getShell(), RefactoringMessages.ExtractMethodAction_dialog_title, 5);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.ExtractMethodAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }
}

