/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic.enricher;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.ObserverAdded;

public class ResolverClassLoaderEnricherObserver {
    private static boolean initDone = false;
    private String configFile = "additional-lib";

    public void initEnricher(@Observes ObserverAdded event) {
        if (initDone || this.configFile == null || !ResolverClassLoaderEnricherObserver.class.isInstance(event.getObserver())) {
            return;
        }
        File file = new File(this.configFile);
        if (file.exists()) {
            ClassLoaderEnricher enricher = (ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class);
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    File lib = new File(ProvisioningUtil.realLocation((String)line));
                    if (lib.exists()) {
                        enricher.addUrl(lib.toURI().toURL());
                        continue;
                    }
                    throw new OpenEJBRuntimeException("can't find " + line);
                }
            }
            catch (Exception e) {
                try {
                    throw new OpenEJBRuntimeException(e);
                }
                catch (Throwable throwable) {
                    IO.close(reader);
                    throw throwable;
                }
            }
            IO.close((Closeable)reader);
        }
        initDone = true;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

