/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;

public class CharacterEscapeHandlerWrapper
implements CharacterEscapeHandler {
    private static final String ESCAPE_METHOD_NAME = "escape";
    private static final Class[] PARAMS = new Class[]{ClassConstants.APCHAR, ClassConstants.PINT, ClassConstants.PINT, ClassConstants.PBOOLEAN, Writer.class};
    private Object handler;
    private Method escapeMethod;

    public CharacterEscapeHandlerWrapper(Object sunHandler) {
        this.handler = sunHandler;
        Class<?> handlerClass = sunHandler.getClass();
        try {
            this.escapeMethod = PrivilegedAccessHelper.getMethod(handlerClass, ESCAPE_METHOD_NAME, PARAMS, false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingCharacterEscapeHandler(ESCAPE_METHOD_NAME, sunHandler, ex);
        }
    }

    @Override
    public void escape(char[] buffer, int start, int length, boolean isAttributeValue, Writer out) throws IOException {
        try {
            Object[] params = new Object[]{buffer, start, length, isAttributeValue, out};
            PrivilegedAccessHelper.invokeMethod(this.escapeMethod, this.handler, params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingCharacterEscapeHandler(ESCAPE_METHOD_NAME, this.handler, ex);
        }
    }

    public Object getHandler() {
        return this.handler;
    }
}

