/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.manifest.internal.core.model;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCoreMessages;
import org.eclipse.virgo.ide.manifest.internal.core.model.AbstractManifestElement;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifest;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifestHeaderElement;
import org.osgi.framework.BundleException;

public class BundleManifestHeader
extends AbstractManifestElement {
    private static final int BUNDLE_MANIFEST_HEADER_TYPE = 1;
    private final int lineNumber;
    private int lines;
    private BundleManifestHeaderElement[] manifestElements;
    private String value;

    protected BundleManifestHeader(BundleManifest parent, String name, String value, int lineNumber) {
        super(parent, name);
        this.value = value;
        this.lineNumber = lineNumber;
        this.lines = 1;
    }

    public void append(String value) {
        this.value = String.valueOf(this.value) + value;
        ++this.lines;
    }

    public BundleManifestHeaderElement[] getBundleManifestHeaderElements() {
        if (this.manifestElements == null) {
            this.init();
        }
        return this.manifestElements;
    }

    public AbstractManifestElement[] getChildren() {
        return this.getBundleManifestHeaderElements();
    }

    public int getElementType() {
        return 1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLinesSpan() {
        return this.lines;
    }

    public String getValue() {
        return this.value;
    }

    public void init() {
        if (this.manifestElements == null) {
            if (this.getValue().trim().length() > 0) {
                try {
                    ManifestElement[] elements;
                    if (StringUtils.countMatches((String)this.getValue(), (String)"\"") % 2 != 0) {
                        throw new BundleException("");
                    }
                    ArrayList<BundleManifestHeaderElement> headerElements = new ArrayList<BundleManifestHeaderElement>();
                    ManifestElement[] manifestElementArray = elements = ManifestElement.parseHeader((String)this.getName(), (String)this.getValue());
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ManifestElement element = manifestElementArray[n2];
                        headerElements.add(new BundleManifestHeaderElement(this, element));
                        ++n2;
                    }
                    this.manifestElements = headerElements.toArray(new BundleManifestHeaderElement[headerElements.size()]);
                }
                catch (BundleException bundleException) {
                    String message = NLS.bind((String)BundleManifestCoreMessages.BundleErrorReporter_parseHeader, (Object)this.getName());
                    ((BundleManifest)this.getParent()).error(2, message, this.getLineNumber() + 1);
                    this.manifestElements = new BundleManifestHeaderElement[0];
                }
            } else {
                this.manifestElements = new BundleManifestHeaderElement[0];
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.lineNumber).append("] ").append(this.getName()).append(" <").append(this.lines).append("> :\n");
        AbstractManifestElement[] abstractManifestElementArray = this.getChildren();
        int n = abstractManifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractManifestElement element = abstractManifestElementArray[n2];
            builder.append("   ").append(element.toString());
            ++n2;
        }
        return builder.toString();
    }
}

