/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.backend;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class QueryEvaluationHint {
    final IQueryBackendFactory queryBackendFactory;
    final Map<QueryHintOption<?>, Object> backendHintSettings;
    final BackendRequirement requirement;

    public QueryEvaluationHint(Map<QueryHintOption<?>, Object> backendHintSettings, BackendRequirement backendRequirementType) {
        Preconditions.checkArgument(backendRequirementType != null, "Specific requirement needs to be set");
        Preconditions.checkArgument(backendRequirementType != BackendRequirement.SPECIFIC, "Specific backend requirement needs providing a corresponding backend type");
        this.queryBackendFactory = null;
        this.requirement = backendRequirementType;
        this.backendHintSettings = backendHintSettings == null ? Collections.emptyMap() : new HashMap(backendHintSettings);
    }

    public QueryEvaluationHint(Map<QueryHintOption<?>, Object> backendHintSettings, IQueryBackendFactory queryBackendFactory) {
        this.queryBackendFactory = queryBackendFactory;
        this.requirement = queryBackendFactory == null ? BackendRequirement.UNSPECIFIED : BackendRequirement.SPECIFIC;
        this.backendHintSettings = backendHintSettings == null ? Collections.emptyMap() : new HashMap(backendHintSettings);
    }

    public BackendRequirement getQueryBackendRequirementType() {
        return this.requirement;
    }

    public IQueryBackendFactory getQueryBackendFactory() {
        return this.queryBackendFactory;
    }

    public Map<QueryHintOption<?>, Object> getBackendHintSettings() {
        return this.backendHintSettings;
    }

    public QueryEvaluationHint overrideBy(QueryEvaluationHint overridingHint) {
        if (overridingHint == null) {
            return this;
        }
        BackendRequirement overriddenRequirement = this.getQueryBackendRequirementType();
        if (overridingHint.getQueryBackendRequirementType() != BackendRequirement.UNSPECIFIED) {
            overriddenRequirement = overridingHint.getQueryBackendRequirementType();
        }
        HashMap hints = new HashMap(this.getBackendHintSettings());
        if (overridingHint.getBackendHintSettings() != null) {
            hints.putAll(overridingHint.getBackendHintSettings());
        }
        if (overriddenRequirement == BackendRequirement.SPECIFIC) {
            IQueryBackendFactory factory = this.getQueryBackendFactory();
            if (overridingHint.getQueryBackendFactory() != null) {
                factory = overridingHint.getQueryBackendFactory();
            }
            return new QueryEvaluationHint(hints, factory);
        }
        return new QueryEvaluationHint(hints, overriddenRequirement);
    }

    public boolean isOptionOverridden(QueryHintOption<?> option) {
        return this.getBackendHintSettings().containsKey(option);
    }

    public <HintValue> HintValue getValueOrNull(QueryHintOption<HintValue> option) {
        return (HintValue)this.getBackendHintSettings().get(option);
    }

    public <HintValue> HintValue getValueOrDefault(QueryHintOption<HintValue> option) {
        return option.getValueOrDefault(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backendHintSettings, this.queryBackendFactory, this.requirement});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryEvaluationHint other = (QueryEvaluationHint)obj;
        return Objects.equals(this.backendHintSettings, other.backendHintSettings) && Objects.equals(this.queryBackendFactory, other.queryBackendFactory) && Objects.equals((Object)this.requirement, (Object)other.requirement);
    }

    public String toString() {
        String result;
        StringBuilder sb = new StringBuilder();
        if (this.getQueryBackendFactory() != null) {
            sb.append("backend: ").append(this.getQueryBackendFactory().getBackendClass().getSimpleName());
        }
        if (!this.backendHintSettings.isEmpty()) {
            sb.append("hints: ");
            if (this.backendHintSettings instanceof AbstractMap) {
                sb.append(this.backendHintSettings.toString());
            } else {
                String joinedHintMap = this.backendHintSettings.entrySet().stream().map(setting -> String.valueOf(setting.getKey()) + "=" + String.valueOf(setting.getValue())).collect(Collectors.joining(", "));
                sb.append('{').append(joinedHintMap).append('}');
            }
        }
        return (result = sb.toString()).isEmpty() ? "defaults" : result;
    }

    public static enum BackendRequirement {
        UNSPECIFIED,
        DEFAULT_SEARCH,
        DEFAULT_CACHING,
        SPECIFIC;

    }
}

