/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timelines;
import org.eclipse.viatra.query.runtime.rete.aggregation.AbstractColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.aggregation.GroupedMap;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public abstract class FaithfulTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult, CumulativeAggregate, FoldingState extends MergeableFoldingState<FoldingState>>
extends AbstractColumnAggregatorNode<Domain, Accumulator, AggregateResult>
implements ResumableNode {
    protected final Map<Tuple, TreeMap<Timestamp, CumulativeAggregate>> aggregates = CollectionsFactory.createMap();
    protected final Map<Tuple, Map<AggregateResult, Timeline<Timestamp>>> timelines = CollectionsFactory.createMap();
    protected final TreeMap<Timestamp, Map<Tuple, FoldingState>> foldingState = CollectionsFactory.createTreeMap();
    protected CommunicationGroup communicationGroup;
    protected static final Timeline<Timestamp> NEUTRAL_INITIAL_TIMELINE = Timestamp.INSERT_AT_ZERO_TIMELINE;
    protected static final Timeline<Timestamp> NON_NEUTRAL_INITIAL_TIMELINE = Timelines.createEmpty();

    public FaithfulTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
        this.mailbox = this.instantiateMailbox();
    }

    @Override
    protected Mailbox instantiateMailbox() {
        return new TimelyMailbox(this, this.reteContainer);
    }

    public void clear() {
        this.mailbox.clear();
        this.aggregates.clear();
        this.timelines.clear();
        this.children.clear();
        this.childMailboxes.clear();
        this.foldingState.clear();
    }

    protected void addFoldingState(Tuple group, FoldingState state, Timestamp timestamp) {
        Map tupleMap = this.foldingState.computeIfAbsent(timestamp, k -> CollectionsFactory.createMap());
        tupleMap.compute(group, (k, v) -> v == null ? state : v.merge(state));
    }

    @Override
    public Timestamp getResumableTimestamp() {
        if (this.foldingState.isEmpty()) {
            return null;
        }
        return this.foldingState.firstKey();
    }

    @Override
    public void resumeAt(Timestamp timestamp) {
        Timestamp current = this.getResumableTimestamp();
        if (current == null) {
            throw new IllegalStateException("There is nothing to fold!");
        }
        if (current.compareTo(timestamp) != 0) {
            throw new IllegalStateException("Expected to continue folding at " + String.valueOf(timestamp) + "!");
        }
        Map<Tuple, FoldingState> tupleMap = this.foldingState.remove(timestamp);
        for (Map.Entry<Tuple, FoldingState> groupEntry : tupleMap.entrySet()) {
            Tuple group = groupEntry.getKey();
            MergeableFoldingState value = (MergeableFoldingState)groupEntry.getValue();
            Map<AggregateResult, Diff<Timestamp>> diffMap = this.doFoldingStep(group, value, timestamp);
            for (Map.Entry<AggregateResult, Diff<Timestamp>> resultEntry : diffMap.entrySet()) {
                for (Signed signed : resultEntry.getValue()) {
                    this.propagate(signed.getDirection(), group, resultEntry.getKey(), (Timestamp)signed.getPayload());
                }
            }
        }
        Timestamp nextTimestamp = this.getResumableTimestamp();
        if (Objects.equals(timestamp, nextTimestamp)) {
            throw new IllegalStateException("Folding at " + String.valueOf(timestamp) + " produced more folding work at the same timestamp!");
        }
        if (nextTimestamp != null) {
            this.communicationGroup.notifyHasMessage(this.mailbox, nextTimestamp);
        }
    }

    protected abstract Map<AggregateResult, Diff<Timestamp>> doFoldingStep(Tuple var1, FoldingState var2, Timestamp var3);

    protected void updateTimeline(Tuple group, Map<AggregateResult, Diff<Timestamp>> diffs) {
        if (!diffs.isEmpty()) {
            this.timelines.compute(group, (k, resultTimelines) -> {
                if (resultTimelines == null) {
                    resultTimelines = CollectionsFactory.createMap();
                }
                for (Map.Entry entry : diffs.entrySet()) {
                    Object result = entry.getKey();
                    resultTimelines.compute(result, (k2, oldResultTimeline) -> {
                        Timeline timeline;
                        Diff currentResultDiffs = (Diff)entry.getValue();
                        if (oldResultTimeline == null) {
                            oldResultTimeline = this.getInitialTimeline(result);
                        }
                        if ((timeline = oldResultTimeline.mergeAdditive(currentResultDiffs)).isEmpty()) {
                            return null;
                        }
                        return timeline;
                    });
                }
                if (resultTimelines.isEmpty()) {
                    return null;
                }
                return resultTimelines;
            });
        }
    }

    protected abstract void gcAggregates(CumulativeAggregate var1, Tuple var2, Timestamp var3);

    protected abstract CumulativeAggregate getAggregate(Tuple var1, Timestamp var2);

    protected Timeline<Timestamp> getInitialTimeline(AggregateResult result) {
        if (this.NEUTRAL == result) {
            return NEUTRAL_INITIAL_TIMELINE;
        }
        return NON_NEUTRAL_INITIAL_TIMELINE;
    }

    protected static <AggregateResult> void appendDiff(AggregateResult result, Signed<Timestamp> diff, Map<AggregateResult, Diff<Timestamp>> diffs) {
        if (result != null) {
            diffs.compute(result, (k, timeLineDiff) -> {
                if (timeLineDiff == null) {
                    timeLineDiff = new Diff();
                }
                timeLineDiff.add((Object)diff);
                return timeLineDiff;
            });
        }
    }

    @Override
    public Tuple getAggregateTuple(Tuple group) {
        return this.tupleFromAggregateResult(group, this.getAggregateResult(group));
    }

    @Override
    public Map<AggregateResult, Timeline<Timestamp>> getAggregateResultTimeline(Tuple group) {
        Map<AggregateResult, Timeline<Timestamp>> resultTimelines = this.timelines.get(group);
        if (resultTimelines == null) {
            if (this.NEUTRAL == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(this.NEUTRAL, NEUTRAL_INITIAL_TIMELINE);
        }
        return resultTimelines;
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getAggregateTupleTimeline(Tuple group) {
        Map<AggregateResult, Timeline<Timestamp>> resultTimelines = this.getAggregateResultTimeline(group);
        return new GroupedMap<AggregateResult, Timeline<Timestamp>>(group, resultTimelines, this.runtimeContext);
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.communicationGroup;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup currentGroup) {
        this.communicationGroup = currentGroup;
    }

    protected static interface MergeableFoldingState<T> {
        public T merge(T var1);
    }
}

