/**
 * Copyright (c) 2010-2016, Peter Lunk, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Peter Lunk - initial API and implementation
 */
package org.eclipse.viatra.transformation.debug.transformationtrace.util;

import java.util.List;
import org.eclipse.viatra.transformation.debug.transformationtrace.model.ActivationTrace;
import org.eclipse.viatra.transformation.debug.transformationtrace.model.RuleParameterTrace;

@SuppressWarnings("all")
public class ActivationTraceUtil {
  public static boolean compareActivationCodes(final ActivationTrace a1, final ActivationTrace a2) {
    boolean retVal = false;
    List<RuleParameterTrace> a1RuleParameterTraces = a1.getRuleParameterTraces();
    List<RuleParameterTrace> a2ruleParameterTraces = a2.getRuleParameterTraces();
    int _size = a1RuleParameterTraces.size();
    int _size_1 = a2ruleParameterTraces.size();
    boolean _equals = (_size == _size_1);
    if (_equals) {
      boolean temp = true;
      for (int i = 0; (i < a1RuleParameterTraces.size()); i++) {
        {
          RuleParameterTrace a1Trace = a1RuleParameterTraces.get(i);
          RuleParameterTrace a2Trace = a2ruleParameterTraces.get(i);
          boolean _or = false;
          String _parameterName = a1Trace.getParameterName();
          String _parameterName_1 = a2Trace.getParameterName();
          boolean _equals_1 = _parameterName.equals(_parameterName_1);
          boolean _not = (!_equals_1);
          if (_not) {
            _or = true;
          } else {
            String _objectId = a1Trace.getObjectId();
            String _objectId_1 = a2Trace.getObjectId();
            boolean _equals_2 = _objectId.equals(_objectId_1);
            boolean _not_1 = (!_equals_2);
            _or = _not_1;
          }
          if (_or) {
            temp = false;
          }
        }
      }
      retVal = temp;
      return retVal;
    }
    return false;
  }
}
