/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.text.build.PropertiesTextChangeListener;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class UpdateSplashProgressOperation
implements IWorkspaceRunnable {
    public static final String F_EXTENSION_PRODUCT = "org.eclipse.core.runtime.products";
    public static final String F_ELEMENT_PRODUCT = "product";
    public static final String F_ELEMENT_PROPERTY = "property";
    public static final String F_ATTRIBUTE_NAME = "name";
    public static final String F_ATTRIBUTE_VALUE = "value";
    public static final String F_ATTRIBUTE_NAME_PREFCUST = "preferenceCustomization";
    public static final String F_KEY_SHOW_PROGRESS = "org.eclipse.ui/SHOW_PROGRESS_ON_STARTUP";
    public static final String F_FILE_NAME_PLUGIN_CUSTOM = "plugin_customization.ini";
    private static final String PLUGIN_URL_PREFIX = "platform:/plugin/";
    private IPluginModelBase fModel;
    private boolean fShowProgress;
    private IProject fProject;
    private String fProductID;
    protected String fPluginId;
    private ITextFileBufferManager fTextFileBufferManager;
    private ITextFileBuffer fTextFileBuffer;
    private PropertiesTextChangeListener fPropertiesListener;

    public UpdateSplashProgressOperation() {
        this.reset();
    }

    public void reset() {
        this.fModel = null;
        this.fProductID = null;
        this.fShowProgress = true;
        this.fProject = null;
        this.fPluginId = null;
        this.fTextFileBufferManager = null;
        this.fPropertiesListener = null;
        this.fTextFileBuffer = null;
    }

    public void setPluginID(String pluginID) {
        this.fPluginId = pluginID;
    }

    public void setModel(IPluginModelBase model) {
        this.fModel = model;
    }

    public void setShowProgress(boolean showProgress) {
        this.fShowProgress = showProgress;
    }

    public void setProductID(String productID) {
        this.fProductID = productID;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.UpdateSplashProgressAction_msgProgressCustomizingSplash, (int)1);
        this.update((IProgressMonitor)subMonitor.split(1));
    }

    private void update(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IPluginExtension productExtension = this.findProductExtension();
        subMonitor.split(1);
        if (productExtension == null) {
            return;
        }
        IPluginElement productElement = this.findProductElement(productExtension);
        subMonitor.split(1);
        if (productElement == null) {
            return;
        }
        IPluginElement propertyElement = this.findPrefCustPropertyElement(productElement);
        subMonitor.split(1);
        if (propertyElement == null && this.fShowProgress) {
            this.addPreferenceCustomizationElement(productElement, (IProgressMonitor)subMonitor.split(1));
        } else if (propertyElement == null) {
            this.updateDefaultPluginCustomizationFile((IProgressMonitor)subMonitor.split(1));
        } else {
            this.updatePreferenceCustomizationElement(propertyElement, (IProgressMonitor)subMonitor.split(1));
        }
    }

    private boolean isAttributeValueDefined(IPluginAttribute valueAttribute) {
        if (valueAttribute == null) {
            return false;
        }
        return PDETextHelper.isDefined((String)valueAttribute.getValue());
    }

    private boolean isFileExist(IResource resource) {
        if (resource == null) {
            return false;
        }
        return resource instanceof IFile;
    }

    private void updatePreferenceCustomizationElement(IPluginElement propertyElement, IProgressMonitor monitor) throws CoreException {
        boolean isFileNotExist;
        boolean isAttributeValueNotDefined;
        IPluginAttribute valueAttribute = propertyElement.getAttribute(F_ATTRIBUTE_VALUE);
        boolean bl = isAttributeValueNotDefined = !this.isAttributeValueDefined(valueAttribute);
        if (isAttributeValueNotDefined && this.fShowProgress) {
            this.createDefaultPluginCustomizationFile(propertyElement, monitor);
            return;
        }
        if (isAttributeValueNotDefined) {
            this.updateDefaultPluginCustomizationFile(monitor);
            return;
        }
        String pluginCustomizationFileName = valueAttribute.getValue();
        int index = pluginCustomizationFileName.indexOf(PLUGIN_URL_PREFIX);
        if (index >= 0) {
            pluginCustomizationFileName = pluginCustomizationFileName.substring(index + PLUGIN_URL_PREFIX.length());
        } else if (pluginCustomizationFileName.equals(F_FILE_NAME_PLUGIN_CUSTOM)) {
            pluginCustomizationFileName = String.valueOf(this.fPluginId) + '/' + pluginCustomizationFileName;
        }
        IResource resource = this.fProject.getWorkspace().getRoot().findMember(pluginCustomizationFileName);
        boolean bl2 = isFileNotExist = !this.isFileExist(resource);
        if (isFileNotExist && this.fShowProgress) {
            this.createDefaultPluginCustomizationFile(propertyElement, monitor);
            return;
        }
        if (isFileNotExist) {
            return;
        }
        this.updatePluginCustomizationFile((IFile)resource, monitor);
    }

    private CoreException createCoreException(String message, Throwable exception) {
        Status status = new Status(4, "org.eclipse.pde.ui", message, exception);
        return new CoreException((IStatus)status);
    }

    private CoreException createCoreException(String message) {
        Status status = new Status(4, "org.eclipse.pde.ui", message);
        return new CoreException((IStatus)status);
    }

    private ITextFileBufferManager getTextFileBufferManager() throws CoreException {
        if (this.fTextFileBufferManager == null) {
            this.fTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        }
        if (this.fTextFileBufferManager == null) {
            throw this.createCoreException(PDEUIMessages.UpdateSplashProgressAction_msgErrorTextFileBufferManager);
        }
        return this.fTextFileBufferManager;
    }

    private ITextFileBuffer getPluginCustomizationBuffer(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        LocationKind kind = LocationKind.IFILE;
        this.fTextFileBuffer = this.getTextFileBufferManager().getTextFileBuffer(path, kind);
        if (this.fTextFileBuffer == null) {
            throw this.createCoreException(PDEUIMessages.UpdateSplashProgressAction_msgErrorTextFileBuffer);
        }
        return this.fTextFileBuffer;
    }

    private BuildModel getBuildModel(IFile file) throws CoreException {
        IDocument document = this.getPluginCustomizationBuffer(file).getDocument();
        BuildModel pluginCustomModel = new BuildModel(document, false);
        pluginCustomModel.setUnderlyingResource((IResource)file);
        pluginCustomModel.setCharset(file.getCharset());
        this.fPropertiesListener = new PropertiesTextChangeListener(document);
        pluginCustomModel.addModelChangedListener((IModelChangedListener)this.fPropertiesListener);
        return pluginCustomModel;
    }

    private void updatePluginCustomizationFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IPath path = file.getFullPath();
        LocationKind kind = LocationKind.IFILE;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        this.getTextFileBufferManager().connect(path, kind, (IProgressMonitor)subMonitor.split(1));
        try {
            try {
                BuildModel pluginCustomModel = this.getBuildModel(file);
                pluginCustomModel.load();
                IBuildEntry showProgressEntry = pluginCustomModel.getBuild().getEntry(F_KEY_SHOW_PROGRESS);
                if (showProgressEntry == null) {
                    this.addShowProgressEntry((IBuildModel)pluginCustomModel);
                } else {
                    this.updateShowProgressEntry(showProgressEntry);
                }
                this.savePluginCustomFileChanges(pluginCustomModel, (IProgressMonitor)subMonitor.split(1));
            }
            catch (MalformedTreeException e) {
                throw this.createCoreException(PDEUIMessages.UpdateSplashProgressAction_msgErrorCustomFileSaveFailed, e);
            }
            catch (BadLocationException e) {
                throw this.createCoreException(PDEUIMessages.UpdateSplashProgressAction_msgErrorCustomFileSaveFailed, e);
            }
        }
        finally {
            this.getTextFileBufferManager().disconnect(path, kind, (IProgressMonitor)subMonitor.split(1));
        }
    }

    private void savePluginCustomFileChanges(BuildModel pluginCustomModel, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!pluginCustomModel.isDirty()) {
            return;
        }
        if (this.fPropertiesListener == null) {
            return;
        }
        if (this.fTextFileBuffer == null) {
            return;
        }
        TextEdit[] edits = this.fPropertiesListener.getTextOperations();
        if (edits.length == 0) {
            return;
        }
        MultiTextEdit multi = new MultiTextEdit();
        multi.addChildren(edits);
        multi.apply(pluginCustomModel.getDocument());
        if (!this.fTextFileBuffer.isDirty()) {
            return;
        }
        this.fTextFileBuffer.commit((IProgressMonitor)subMonitor.split(1), true);
    }

    private String getBooleanValue(boolean value) {
        if (value) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private void updateShowProgressEntry(IBuildEntry showProgressEntry) throws CoreException {
        String newBooleanValue = this.getBooleanValue(this.fShowProgress);
        String[] values = showProgressEntry.getTokens();
        if (values.length == 0) {
            showProgressEntry.addToken(newBooleanValue);
            return;
        }
        if (values.length > 1) {
            this.removeEntryTokens(showProgressEntry, values);
            showProgressEntry.addToken(newBooleanValue);
            return;
        }
        String oldBooleanValue = values[0];
        if (!oldBooleanValue.equals(newBooleanValue)) {
            showProgressEntry.renameToken(oldBooleanValue, newBooleanValue);
        }
    }

    private void removeEntryTokens(IBuildEntry showProgressEntry, String[] values) throws CoreException {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            showProgressEntry.removeToken(value);
            ++n2;
        }
    }

    private void addShowProgressEntry(IBuildModel pluginCustomModel) throws CoreException {
        IBuildEntry showProgressEntry = pluginCustomModel.getFactory().createEntry(F_KEY_SHOW_PROGRESS);
        showProgressEntry.addToken(this.getBooleanValue(this.fShowProgress));
        pluginCustomModel.getBuild().add(showProgressEntry);
    }

    private void createPluginCustomizationFile() throws CoreException {
        IFile file = this.fProject.getFile(F_FILE_NAME_PLUGIN_CUSTOM);
        WorkspaceBuildModel pluginCustomModel = new WorkspaceBuildModel(file);
        this.addShowProgressEntry((IBuildModel)pluginCustomModel);
        pluginCustomModel.save();
        IFile buildProps = PDEProject.getBuildProperties((IProject)this.fProject);
        if (buildProps.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProps);
            model.load();
            if (model.isLoaded()) {
                IBuildEntry entry = model.getBuild().getEntry("bin.includes");
                if (entry == null) {
                    entry = model.getFactory().createEntry("bin.includes");
                    model.getBuild().add(entry);
                }
                if (!entry.contains(F_FILE_NAME_PLUGIN_CUSTOM)) {
                    entry.addToken(F_FILE_NAME_PLUGIN_CUSTOM);
                }
                model.save();
            }
        }
    }

    private void addPreferenceCustomizationElement(IPluginElement productElement, IProgressMonitor monitor) throws CoreException {
        IExtensionsModelFactory factory = productElement.getModel().getFactory();
        IPluginElement propertyElement = factory.createElement((IPluginObject)productElement);
        propertyElement.setName(F_ELEMENT_PROPERTY);
        propertyElement.setAttribute(F_ATTRIBUTE_NAME, F_ATTRIBUTE_NAME_PREFCUST);
        productElement.add((IPluginObject)propertyElement);
        this.createDefaultPluginCustomizationFile(propertyElement, monitor);
    }

    private void createDefaultPluginCustomizationFile(IPluginElement propertyElement, IProgressMonitor monitor) throws CoreException {
        propertyElement.setAttribute(F_ATTRIBUTE_VALUE, F_FILE_NAME_PLUGIN_CUSTOM);
        IResource resource = this.fProject.findMember(F_FILE_NAME_PLUGIN_CUSTOM);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (this.isFileExist(resource)) {
            this.updatePluginCustomizationFile((IFile)resource, (IProgressMonitor)subMonitor.split(1));
        } else {
            subMonitor.split(1);
            this.createPluginCustomizationFile();
        }
    }

    private void updateDefaultPluginCustomizationFile(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IResource resource = this.fProject.findMember(F_FILE_NAME_PLUGIN_CUSTOM);
        if (this.isFileExist(resource)) {
            this.updatePluginCustomizationFile((IFile)resource, (IProgressMonitor)subMonitor.split(1));
        }
    }

    private IPluginElement findPrefCustPropertyElement(IPluginElement productElement) {
        IPluginObject[] objects;
        if (productElement.getChildCount() == 0) {
            return null;
        }
        IPluginObject[] iPluginObjectArray = objects = productElement.getChildren();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement element;
            IPluginAttribute nameAttribute;
            IPluginObject object = iPluginObjectArray[n2];
            if (object instanceof IPluginElement && object.getName().equals(F_ELEMENT_PROPERTY) && (nameAttribute = (element = (IPluginElement)object).getAttribute(F_ATTRIBUTE_NAME)) != null && PDETextHelper.isDefined((String)nameAttribute.getValue()) && nameAttribute.getValue().equals(F_ATTRIBUTE_NAME_PREFCUST)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private IPluginElement findProductElement(IPluginExtension extension) {
        if (extension.getChildCount() != 1) {
            return null;
        }
        IPluginObject pluginObject = extension.getChildren()[0];
        if (!(pluginObject instanceof IPluginElement)) {
            return null;
        }
        if (!pluginObject.getName().equals(F_ELEMENT_PRODUCT)) {
            return null;
        }
        return (IPluginElement)pluginObject;
    }

    private IPluginExtension findProductExtension() {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = this.fModel.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            if (point.equals(F_EXTENSION_PRODUCT) && (id = String.valueOf(this.fPluginId) + '.' + extension.getId()).equals(this.fProductID)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }
}

