/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class JDTProjectNatureImportConfigurator
implements ProjectConfigurator {
    private static final String BIN = "bin";
    private static final String CLASSPATH = ".classpath";

    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            List<String> natures = Arrays.asList(description.getNatureIds());
            if (!natures.contains("org.eclipse.jdt.core.javanature")) {
                ArrayList<String> newNatures = new ArrayList<String>(natures);
                newNatures.add("org.eclipse.jdt.core.javanature");
                description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                project.setDescription(description, monitor);
            }
        }
        catch (Exception ex) {
            JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.core", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile((IPath)new Path(CLASSPATH)).exists();
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (javaProject == null) {
                return Collections.emptySet();
            }
            IResource resource = project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
            if (resource != null && resource.exists() && resource.getType() == 2) {
                res.add((IFolder)resource);
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IFolder sourceFolder = project.getFolder(entry.getPath());
                    res.add(sourceFolder);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.core", ex.getMessage(), (Throwable)ex));
        }
        return res;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return null;
    }

    public void removeDirtyDirectories(Map<File, List<ProjectConfigurator>> proposals) {
        HashSet<File> toRemove = new HashSet<File>();
        for (File directory : proposals.keySet()) {
            File potentialClasspathFile;
            int index;
            String path = directory.getAbsolutePath();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
            if ((index = path.indexOf(String.valueOf(File.separator) + BIN + File.separator)) < 0 || !(potentialClasspathFile = new File(path.substring(0, index), CLASSPATH)).isFile()) continue;
            toRemove.add(directory);
        }
        for (File directory : toRemove) {
            proposals.remove(directory);
        }
    }
}

