/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.FrameInitializationCheck;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class SearchPlanForBody {
    private PBody body;
    private Map<PVariable, Integer> variableKeys;
    private int[] parameterKeys;
    private SubPlan plan;
    private List<ISearchOperation> compiledOperations;
    private Collection<MatcherReference> dependencies;

    public SearchPlanForBody(PBody body, Map<PVariable, Integer> variableKeys, SubPlan plan, List<ISearchOperation> compiledOperations, Collection<MatcherReference> dependencies) {
        this.body = body;
        this.variableKeys = variableKeys;
        this.plan = plan;
        List parameters = body.getSymbolicParameterVariables();
        this.parameterKeys = new int[parameters.size()];
        int i = 0;
        while (i < parameters.size()) {
            this.parameterKeys[i] = variableKeys.get(parameters.get(i));
            ++i;
        }
        this.compiledOperations = Lists.newArrayListWithCapacity((int)(compiledOperations.size() + 1));
        this.compiledOperations.add(new FrameInitializationCheck(this.parameterKeys));
        this.compiledOperations.addAll(compiledOperations);
        this.dependencies = Lists.newArrayList(dependencies);
    }

    public PBody getBody() {
        return this.body;
    }

    public Map<PVariable, Integer> getVariableKeys() {
        return this.variableKeys;
    }

    public int[] getParameterKeys() {
        return Arrays.copyOf(this.parameterKeys, this.parameterKeys.length);
    }

    public List<ISearchOperation> getCompiledOperations() {
        return this.compiledOperations;
    }

    public SubPlan getPlan() {
        return this.plan;
    }

    public Collection<MatcherReference> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.compiledOperations);
    }
}

