/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.IAdornmentProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchGenericBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHintOptions;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.IndexerBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.VariableBindingBasedCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.CommonQueryHintOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.DefaultFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.NeverFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.NopTraceCollector;

public final class LocalSearchHints
implements IMatcherCapability {
    private Boolean useBase = null;
    private Integer rowCount = null;
    private ICostFunction costFunction = null;
    private IFlattenCallPredicate flattenCallPredicate = null;
    private IAdornmentProvider adornmentProvider = null;
    private IRewriterTraceCollector traceCollector = NopTraceCollector.INSTANCE;
    private IQueryBackendFactory backendFactory = null;

    private LocalSearchHints() {
    }

    public static LocalSearchHints getDefaultOverriddenBy(QueryEvaluationHint overridingHint) {
        return LocalSearchHints.parse(LocalSearchHints.getDefault().build().overrideBy(overridingHint));
    }

    public static LocalSearchHints getDefault() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = (Boolean)LocalSearchHintOptions.USE_BASE_INDEX.getDefaultValue();
        result.rowCount = (Integer)LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.getDefaultValue();
        result.costFunction = (ICostFunction)LocalSearchHintOptions.PLANNER_COST_FUNCTION.getDefaultValue();
        result.flattenCallPredicate = (IFlattenCallPredicate)LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.getDefaultValue();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultFlatten() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = true;
        result.rowCount = 4;
        result.costFunction = new IndexerBasedConstraintCostFunction();
        result.flattenCallPredicate = new DefaultFlattenCallPredicate();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultNoBase() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = false;
        result.rowCount = 4;
        result.costFunction = new VariableBindingBasedCostFunction();
        result.flattenCallPredicate = new NeverFlattenCallPredicate();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultGeneric() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = true;
        result.rowCount = 4;
        result.costFunction = new VariableBindingBasedCostFunction();
        result.flattenCallPredicate = new NeverFlattenCallPredicate();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchGenericBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints parse(QueryEvaluationHint hint) {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = (Boolean)LocalSearchHintOptions.USE_BASE_INDEX.getValueOrNull(hint);
        result.rowCount = (Integer)LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.getValueOrNull(hint);
        result.flattenCallPredicate = (IFlattenCallPredicate)LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.getValueOrNull(hint);
        result.costFunction = (ICostFunction)LocalSearchHintOptions.PLANNER_COST_FUNCTION.getValueOrNull(hint);
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getValueOrNull(hint);
        result.traceCollector = (IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getValueOrDefault(hint);
        return result;
    }

    public QueryEvaluationHint build() {
        HashMap map = Maps.newHashMap();
        if (this.useBase != null) {
            LocalSearchHintOptions.USE_BASE_INDEX.insertOverridingValue((Map)map, (Object)this.useBase);
        }
        if (this.rowCount != null) {
            LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.insertOverridingValue((Map)map, (Object)this.rowCount);
        }
        if (this.costFunction != null) {
            LocalSearchHintOptions.PLANNER_COST_FUNCTION.insertOverridingValue((Map)map, (Object)this.costFunction);
        }
        if (this.flattenCallPredicate != null) {
            LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.insertOverridingValue((Map)map, (Object)this.flattenCallPredicate);
        }
        if (this.adornmentProvider != null) {
            LocalSearchHintOptions.ADORNMENT_PROVIDER.insertOverridingValue((Map)map, (Object)this.adornmentProvider);
        }
        if (this.traceCollector != null) {
            CommonQueryHintOptions.normalizationTraceCollector.insertOverridingValue((Map)map, (Object)this.traceCollector);
        }
        return new QueryEvaluationHint((Map)map, this.backendFactory);
    }

    public boolean isUseBase() {
        return this.useBase;
    }

    @Deprecated
    public Boolean isAllowInverse() {
        return true;
    }

    public ICostFunction getCostFunction() {
        return this.costFunction;
    }

    public IFlattenCallPredicate getFlattenCallPredicate() {
        return this.flattenCallPredicate;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public IAdornmentProvider getAdornmentProvider() {
        return this.adornmentProvider;
    }

    public IRewriterTraceCollector getTraceCollector() {
        return this.traceCollector == null ? (IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getDefaultValue() : this.traceCollector;
    }

    @Deprecated
    public LocalSearchHints setAllowInverse(boolean allowInverse) {
        return this;
    }

    public LocalSearchHints setUseBase(boolean useBase) {
        this.useBase = useBase;
        return this;
    }

    public LocalSearchHints setRowCount(int rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public LocalSearchHints setCostFunction(ICostFunction costFunction) {
        this.costFunction = costFunction;
        return this;
    }

    public LocalSearchHints setFlattenCallPredicate(IFlattenCallPredicate flattenCallPredicate) {
        this.flattenCallPredicate = flattenCallPredicate;
        return this;
    }

    public LocalSearchHints setTraceCollector(IRewriterTraceCollector traceCollector) {
        this.traceCollector = traceCollector;
        return this;
    }

    public LocalSearchHints setAdornmentProvider(IAdornmentProvider adornmentProvider) {
        this.adornmentProvider = adornmentProvider;
        return this;
    }

    public static LocalSearchHints customizeUseBase(boolean useBase) {
        return new LocalSearchHints().setUseBase(useBase);
    }

    @Deprecated
    public static LocalSearchHints customizeAllowInverse(boolean allowInverse) {
        return new LocalSearchHints();
    }

    public static LocalSearchHints customizeRowCount(int rowCount) {
        return new LocalSearchHints().setRowCount(rowCount);
    }

    public static LocalSearchHints customizeCostFunction(ICostFunction costFunction) {
        return new LocalSearchHints().setCostFunction(costFunction);
    }

    public static LocalSearchHints customizeFlattenCallPredicate(IFlattenCallPredicate predicate) {
        return new LocalSearchHints().setFlattenCallPredicate(predicate);
    }

    public static LocalSearchHints customizeAdornmentProvider(IAdornmentProvider adornmentProvider) {
        return new LocalSearchHints().setAdornmentProvider(adornmentProvider);
    }

    public static LocalSearchHints customizeTraceCollector(IRewriterTraceCollector traceCollector) {
        return new LocalSearchHints().setTraceCollector(traceCollector);
    }

    public boolean canBeSubstitute(IMatcherCapability capability) {
        if (capability instanceof LocalSearchHints) {
            LocalSearchHints other = (LocalSearchHints)capability;
            return Objects.equal((Object)other.useBase, (Object)this.useBase);
        }
        return false;
    }
}

