/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.deployment.DeploymentPackage;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityPackage;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.ApplicationInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.ApplicationInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.HostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.HostInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMachineMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TransitionMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TriggerPairMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TriggerPairMatcher;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven.EventDrivenTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven.EventDrivenTransformationRuleFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RuleProvider {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.incr.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = new Functions.Function0<CpsXformM2M>(){

        public CpsXformM2M apply() {
            try {
                CpsXformM2M _instance = CpsXformM2M.instance();
                return _instance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    @Extension
    private IModelManipulations manipulation;
    @Extension
    private DeploymentPackage depPackage = DeploymentPackage.eINSTANCE;
    @Extension
    private TraceabilityPackage trPackage = TraceabilityPackage.eINSTANCE;
    @Extension
    private EventDrivenTransformationRuleFactory factory = new EventDrivenTransformationRuleFactory();
    private CPSToDeployment cps2dep;
    private ViatraQueryEngine engine;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> hostRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> applicationRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateMachineRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> transitionRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> triggerRule;

    public RuleProvider(ViatraQueryEngine engine, CPSToDeployment cps2dep) {
        this.engine = engine;
        this.cps2dep = cps2dep;
        SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(engine);
        this.manipulation = _simpleModelManipulations;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getHostRule() {
        try {
            boolean _equals = Objects.equal(this.hostRule, null);
            if (_equals) {
                IMatchProcessor<HostInstanceMatch> _function = new IMatchProcessor<HostInstanceMatch>(){

                    public void process(HostInstanceMatch it) {
                        try {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping host with IP: ");
                            String _nodeIp = it.getHostInstance().getNodeIp();
                            _builder.append((Object)_nodeIp);
                            RuleProvider.this.logger.debug((Object)_builder);
                            EObject deploymentHost = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep.getDeployment(), RuleProvider.this.depPackage.getDeployment_Hosts(), RuleProvider.this.depPackage.getDeploymentHost());
                            RuleProvider.this.manipulation.set(deploymentHost, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentHost_Ip(), (Object)it.getHostInstance().getNodeIp());
                            EObject hostTrace = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep, RuleProvider.this.trPackage.getCPSToDeployment_Traces(), RuleProvider.this.trPackage.getCPS2DeploymentTrace());
                            RuleProvider.this.manipulation.addTo(hostTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getHostInstance());
                            RuleProvider.this.manipulation.addTo(hostTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)deploymentHost);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<HostInstanceMatch> _function_1 = new IMatchProcessor<HostInstanceMatch>(){

                    public void process(HostInstanceMatch it) {
                        try {
                            DeploymentElement _depElement = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getOneArbitraryMatch(RuleProvider.this.cps2dep, null, (Identifiable)it.getHostInstance(), null).getDepElement();
                            DeploymentHost depHost = (DeploymentHost)_depElement;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Updating mapped host with IP: ");
                            String _ip = depHost.getIp();
                            _builder.append((Object)_ip);
                            RuleProvider.this.logger.debug((Object)_builder);
                            RuleProvider.this.manipulation.set((EObject)depHost, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentHost_Ip(), (Object)it.getHostInstance().getNodeIp());
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append((Object)"Updated mapped host with IP: ");
                            String _ip_1 = depHost.getIp();
                            _builder_1.append((Object)_ip_1);
                            RuleProvider.this.logger.debug((Object)_builder_1);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<HostInstanceMatch> _function_2 = new IMatchProcessor<HostInstanceMatch>(){

                    public void process(HostInstanceMatch it) {
                        try {
                            Cps2depTraceMatch traceMatch = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getOneArbitraryMatch(RuleProvider.this.cps2dep, null, (Identifiable)it.getHostInstance(), null);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Removing host with IP: ");
                            String _nodeIp = it.getHostInstance().getNodeIp();
                            _builder.append((Object)_nodeIp);
                            RuleProvider.this.logger.debug((Object)_builder);
                            RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep.getDeployment(), (EStructuralFeature)RuleProvider.this.depPackage.getDeployment_Hosts(), (Object)traceMatch.getDepElement());
                            RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep, (EStructuralFeature)RuleProvider.this.trPackage.getCPSToDeployment_Traces(), (Object)traceMatch.getTrace());
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append((Object)"Removed host with IP: ");
                            String _nodeIp_1 = it.getHostInstance().getNodeIp();
                            _builder_1.append((Object)_nodeIp_1);
                            RuleProvider.this.logger.debug((Object)_builder_1);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.hostRule = this.factory.createRule().name("HostRule").precondition(HostInstanceMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.hostRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getApplicationRule() {
        try {
            boolean _equals = Objects.equal(this.applicationRule, null);
            if (_equals) {
                IMatchProcessor<ApplicationInstanceMatch> _function = new IMatchProcessor<ApplicationInstanceMatch>(){

                    public void process(ApplicationInstanceMatch it) {
                        try {
                            DeploymentHost depHost = (DeploymentHost)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance().getAllocatedTo()), DeploymentHost.class));
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping application with ID: ");
                            String _identifier = it.getAppInstance().getIdentifier();
                            _builder.append((Object)_identifier);
                            RuleProvider.this.logger.debug((Object)_builder);
                            EObject deploymentApplication = RuleProvider.this.manipulation.createChild((EObject)depHost, RuleProvider.this.depPackage.getDeploymentHost_Applications(), RuleProvider.this.depPackage.getDeploymentApplication());
                            RuleProvider.this.manipulation.set(deploymentApplication, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentApplication_Id(), (Object)it.getAppInstance().getIdentifier());
                            EObject hostTrace = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep, RuleProvider.this.trPackage.getCPSToDeployment_Traces(), RuleProvider.this.trPackage.getCPS2DeploymentTrace());
                            RuleProvider.this.manipulation.addTo(hostTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getAppInstance());
                            RuleProvider.this.manipulation.addTo(hostTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)deploymentApplication);
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append((Object)"Mapped application with ID: ");
                            String _identifier_1 = it.getAppInstance().getIdentifier();
                            _builder_1.append((Object)_identifier_1);
                            RuleProvider.this.logger.debug((Object)_builder_1);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<ApplicationInstanceMatch> _function_1 = new IMatchProcessor<ApplicationInstanceMatch>(){

                    public void process(ApplicationInstanceMatch it) {
                        try {
                            boolean _notEquals;
                            DeploymentElement _depElement = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getOneArbitraryMatch(RuleProvider.this.cps2dep, null, (Identifiable)it.getAppInstance(), null).getDepElement();
                            DeploymentApplication depApp = (DeploymentApplication)_depElement;
                            String _id = depApp.getId();
                            String _identifier = it.getAppInstance().getIdentifier();
                            boolean bl = _notEquals = !Objects.equal((Object)_id, (Object)_identifier);
                            if (_notEquals) {
                                RuleProvider.this.manipulation.set((EObject)depApp, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentApplication_Id(), (Object)it.getAppInstance().getIdentifier());
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<ApplicationInstanceMatch> _function_2 = new IMatchProcessor<ApplicationInstanceMatch>(){

                    public void process(ApplicationInstanceMatch it) {
                        try {
                            CPS2DeploymentTrace _head;
                            CPS2DeploymentTrace trace = _head = (CPS2DeploymentTrace)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)it.getAppInstance(), null));
                            DeploymentElement _head_1 = (DeploymentElement)IterableExtensions.head((Iterable)trace.getDeploymentElements());
                            DeploymentApplication depApp = (DeploymentApplication)_head_1;
                            RuleProvider.this.manipulation.remove((EObject)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getAllocatedDeploymentApplication(RuleProvider.this.engine).getAllValuesOfdepHost(depApp)), (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentHost_Applications(), (Object)depApp);
                            RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep, (EStructuralFeature)RuleProvider.this.trPackage.getCPSToDeployment_Traces(), (Object)trace);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.applicationRule = this.factory.createRule().name("ApplicationRule").precondition(ApplicationInstanceMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.applicationRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateMachineRule() {
        try {
            boolean _equals = Objects.equal(this.stateMachineRule, null);
            if (_equals) {
                IMatchProcessor<StateMachineMatch> _function = new IMatchProcessor<StateMachineMatch>(){

                    public void process(StateMachineMatch it) {
                        try {
                            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping state machine with ID: ");
                            String _identifier = it.getStateMachine().getIdentifier();
                            _builder.append((Object)_identifier);
                            RuleProvider.this.logger.debug((Object)_builder);
                            EObject _createChild = RuleProvider.this.manipulation.createChild((EObject)depApp, RuleProvider.this.depPackage.getDeploymentApplication_Behavior(), RuleProvider.this.depPackage.getDeploymentBehavior());
                            DeploymentBehavior behavior = (DeploymentBehavior)_createChild;
                            RuleProvider.this.manipulation.set((EObject)behavior, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)it.getStateMachine().getIdentifier());
                            RuleProvider.this.manipulation.set((EObject)depApp, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentApplication_Behavior(), (Object)behavior);
                            Set<CPS2DeploymentTrace> traces = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)it.getStateMachine(), null);
                            boolean _isEmpty = traces.isEmpty();
                            if (_isEmpty) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Creating new trace for state machine");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                EObject trace = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep, RuleProvider.this.trPackage.getCPSToDeployment_Traces(), RuleProvider.this.trPackage.getCPS2DeploymentTrace());
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getStateMachine());
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)behavior);
                            } else {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append((Object)"Adding new behavior to existing trace");
                                RuleProvider.this.logger.trace((Object)_builder_2);
                                RuleProvider.this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)behavior);
                            }
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append((Object)"Mapped state machine with ID: ");
                            String _identifier_1 = it.getStateMachine().getIdentifier();
                            _builder_3.append((Object)_identifier_1);
                            RuleProvider.this.logger.debug((Object)_builder_3);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<StateMachineMatch> _function_1 = new IMatchProcessor<StateMachineMatch>(){

                    public void process(StateMachineMatch it) {
                        try {
                            final String smId = it.getStateMachine().getIdentifier();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Updating mapped state machine with ID: ");
                            _builder.append((Object)smId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            Iterable depSMs = Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getStateMachine()), DeploymentBehavior.class);
                            Procedures.Procedure1<DeploymentBehavior> _function = new Procedures.Procedure1<DeploymentBehavior>(){

                                public void apply(DeploymentBehavior it) {
                                    try {
                                        boolean _notEquals;
                                        String _description = it.getDescription();
                                        boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)smId);
                                        if (_notEquals) {
                                            StringConcatenation _builder = new StringConcatenation();
                                            _builder.append((Object)"ID changed to ");
                                            _builder.append((Object)smId);
                                            RuleProvider.this.logger.trace((Object)_builder);
                                            RuleProvider.this.manipulation.set((EObject)it, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)smId);
                                        }
                                    }
                                    catch (Throwable _e) {
                                        throw Exceptions.sneakyThrow((Throwable)_e);
                                    }
                                }
                            };
                            IterableExtensions.forEach((Iterable)depSMs, (Procedures.Procedure1)_function);
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append((Object)"Updated mapped state machine with ID: ");
                            _builder_1.append((Object)smId);
                            RuleProvider.this.logger.debug((Object)_builder_1);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<StateMachineMatch> _function_2 = new IMatchProcessor<StateMachineMatch>(){

                    public void process(StateMachineMatch it) {
                        try {
                            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                            DeploymentApplication depApp = (DeploymentApplication)_head;
                            DeploymentBehavior depBehavior = depApp.getBehavior();
                            String smId = depBehavior.getDescription();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Removing state machine with ID: ");
                            _builder.append((Object)smId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            RuleProvider.this.manipulation.set((EObject)depApp, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentApplication_Behavior(), null);
                            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)it.getStateMachine(), null));
                            RuleProvider.this.manipulation.remove((EObject)smTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depBehavior);
                            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                            if (_isEmpty) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Removing empty trace");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep, (EStructuralFeature)RuleProvider.this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                            }
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append((Object)"Removed state machine with ID: ");
                            _builder_2.append((Object)smId);
                            RuleProvider.this.logger.debug((Object)_builder_2);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.stateMachineRule = this.factory.createRule().name("StateMachineRule").precondition(StateMachineMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.stateMachineRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateRule() {
        try {
            boolean _equals = Objects.equal(this.stateRule, null);
            if (_equals) {
                IMatchProcessor<StateMatch> _function = new IMatchProcessor<StateMatch>(){

                    public void process(StateMatch it) {
                        try {
                            Set<CPS2DeploymentTrace> traces;
                            boolean _isEmpty;
                            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                            DeploymentApplication depApp = (DeploymentApplication)_head;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping state with ID: ");
                            String _identifier = it.getState().getIdentifier();
                            _builder.append((Object)_identifier);
                            RuleProvider.this.logger.debug((Object)_builder);
                            EObject depState = RuleProvider.this.manipulation.createChild((EObject)depApp.getBehavior(), RuleProvider.this.depPackage.getDeploymentBehavior_States(), RuleProvider.this.depPackage.getBehaviorState());
                            RuleProvider.this.manipulation.set(depState, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)it.getState().getIdentifier());
                            State _initial = it.getStateMachine().getInitial();
                            State _state = it.getState();
                            boolean _equals = Objects.equal((Object)_initial, (Object)_state);
                            if (_equals) {
                                RuleProvider.this.manipulation.set((EObject)depApp.getBehavior(), (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentBehavior_Current(), (Object)depState);
                            }
                            if (_isEmpty = (traces = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)it.getState(), null)).isEmpty()) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Creating new trace for state ");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                EObject trace = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep, RuleProvider.this.trPackage.getCPSToDeployment_Traces(), RuleProvider.this.trPackage.getCPS2DeploymentTrace());
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getState());
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                            } else {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append((Object)"Adding new state to existing trace");
                                RuleProvider.this.logger.trace((Object)_builder_2);
                                RuleProvider.this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                            }
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append((Object)"Mapped state with ID: ");
                            String _identifier_1 = it.getState().getIdentifier();
                            _builder_3.append((Object)_identifier_1);
                            RuleProvider.this.logger.debug((Object)_builder_3);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<StateMatch> _function_1 = new IMatchProcessor<StateMatch>(){

                    public void process(StateMatch it) {
                        try {
                            State _initial;
                            State _state;
                            boolean _equals;
                            boolean _notEquals;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Updating mapped state with ID: ");
                            String _identifier = it.getState().getIdentifier();
                            _builder.append((Object)_identifier);
                            RuleProvider.this.logger.debug((Object)_builder);
                            final DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                            Functions.Function1<BehaviorState, Boolean> _function = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return depApp.getBehavior().getStates().contains((Object)it);
                                }
                            };
                            BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getState()), BehaviorState.class), (Functions.Function1)_function);
                            DeploymentBehavior depBehavior = depApp.getBehavior();
                            String _description = depState.getDescription();
                            String _identifier_1 = it.getState().getIdentifier();
                            boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)_identifier_1);
                            if (_notEquals) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"ID changed to ");
                                String _identifier_2 = it.getState().getIdentifier();
                                _builder_1.append((Object)_identifier_2);
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.set((EObject)depState, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)it.getState().getIdentifier());
                            }
                            if (_equals = Objects.equal((Object)(_state = it.getState()), (Object)(_initial = it.getStateMachine().getInitial()))) {
                                boolean _notEquals_1;
                                BehaviorState _current = depBehavior.getCurrent();
                                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_current, (Object)depState);
                                if (_notEquals_1) {
                                    StringConcatenation _builder_2 = new StringConcatenation();
                                    _builder_2.append((Object)"Current state changed to ");
                                    String _identifier_3 = it.getState().getIdentifier();
                                    _builder_2.append((Object)_identifier_3);
                                    RuleProvider.this.logger.trace((Object)_builder_2);
                                    RuleProvider.this.manipulation.set((EObject)depBehavior, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentBehavior_Current(), (Object)depState);
                                }
                            }
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append((Object)"Updated mapped state with ID: ");
                            String _identifier_4 = it.getState().getIdentifier();
                            _builder_3.append((Object)_identifier_4);
                            RuleProvider.this.logger.debug((Object)_builder_3);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<StateMatch> _function_2 = new IMatchProcessor<StateMatch>(){

                    public void process(StateMatch it) {
                        try {
                            boolean _notEquals;
                            DeploymentElement _head = (DeploymentElement)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                            final DeploymentApplication depApp = (DeploymentApplication)_head;
                            DeploymentBehavior depBehavior = depApp.getBehavior();
                            Functions.Function1<BehaviorState, Boolean> _function = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return depApp.getBehavior().getStates().contains((Object)it);
                                }
                            };
                            BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getState()), BehaviorState.class), (Functions.Function1)_function);
                            String stateId = depState.getDescription();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Removing state with ID: ");
                            _builder.append((Object)stateId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            boolean bl = _notEquals = !Objects.equal((Object)depBehavior, null);
                            if (_notEquals) {
                                RuleProvider.this.manipulation.remove((EObject)depBehavior, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentBehavior_States(), (Object)depState);
                                BehaviorState _current = depBehavior.getCurrent();
                                boolean _equals = Objects.equal((Object)_current, (Object)depState);
                                if (_equals) {
                                    RuleProvider.this.manipulation.set((EObject)depBehavior, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentBehavior_Current(), null);
                                }
                            }
                            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)it.getState(), null));
                            RuleProvider.this.manipulation.remove((EObject)smTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                            if (_isEmpty) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Removing empty trace");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep, (EStructuralFeature)RuleProvider.this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                            }
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append((Object)"Removed state with ID: ");
                            _builder_2.append((Object)stateId);
                            RuleProvider.this.logger.debug((Object)_builder_2);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.stateRule = this.factory.createRule().name("StateRule").precondition(StateMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.stateRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTransitionRule() {
        try {
            boolean _equals = Objects.equal(this.transitionRule, null);
            if (_equals) {
                IMatchProcessor<TransitionMatch> _function = new IMatchProcessor<TransitionMatch>(){

                    public void process(TransitionMatch it) {
                        try {
                            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                            Transition transition = it.getTransition();
                            String transitionId = transition.getIdentifier();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping transition with ID: ");
                            _builder.append((Object)transitionId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            EObject depTransition = RuleProvider.this.manipulation.createChild((EObject)depApp.getBehavior(), RuleProvider.this.depPackage.getDeploymentBehavior_Transitions(), RuleProvider.this.depPackage.getBehaviorTransition());
                            RuleProvider.this.manipulation.set(depTransition, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)transitionId);
                            final Set<DeploymentElement> tempDepSources = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                            Functions.Function1<BehaviorState, Boolean> _function = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return tempDepSources.contains(it);
                                }
                            };
                            BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function);
                            RuleProvider.this.manipulation.addTo((EObject)depSource, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                            final Set<DeploymentElement> tempDepTargets = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition.getTargetState());
                            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return tempDepTargets.contains(it);
                                }
                            };
                            BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
                            RuleProvider.this.manipulation.set(depTransition, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorTransition_To(), (Object)depTarget);
                            Set<CPS2DeploymentTrace> traces = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)transition, null);
                            boolean _isEmpty = traces.isEmpty();
                            if (_isEmpty) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Creating new trace for transition ");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                EObject trace = RuleProvider.this.manipulation.createChild((EObject)RuleProvider.this.cps2dep, RuleProvider.this.trPackage.getCPSToDeployment_Traces(), RuleProvider.this.trPackage.getCPS2DeploymentTrace());
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)transition);
                                RuleProvider.this.manipulation.addTo(trace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                            } else {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append((Object)"Adding new transition to existing trace");
                                RuleProvider.this.logger.trace((Object)_builder_2);
                                RuleProvider.this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                            }
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append((Object)"Mapped transition with ID: ");
                            _builder_3.append((Object)transitionId);
                            RuleProvider.this.logger.debug((Object)_builder_3);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<TransitionMatch> _function_1 = new IMatchProcessor<TransitionMatch>(){

                    public void process(TransitionMatch it) {
                        try {
                            BehaviorState _to;
                            boolean _notEquals_1;
                            boolean _not;
                            boolean _notEquals;
                            Transition transition = it.getTransition();
                            String trId = transition.getIdentifier();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Updating mapped transition with ID: ");
                            _builder.append((Object)trId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                            final Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
                            Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depTransitions.contains(it);
                                }
                            };
                            BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getTransitions(), (Functions.Function1)_function);
                            String oldDesc = depTransition.getDescription();
                            boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)trId);
                            if (_notEquals) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"ID changed to ");
                                _builder_1.append((Object)oldDesc);
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.set((EObject)depTransition, (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentElement_Description(), (Object)trId);
                            }
                            final Set<DeploymentElement> tempDepSources = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return tempDepSources.contains(it);
                                }
                            };
                            BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
                            final Set<DeploymentElement> tempDepTargets = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition.getTargetState());
                            Functions.Function1<BehaviorState, Boolean> _function_2 = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return tempDepTargets.contains(it);
                                }
                            };
                            BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_2);
                            boolean _contains = depSource.getOutgoing().contains((Object)depTransition);
                            boolean bl2 = _not = !_contains;
                            if (_not) {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append((Object)"Source state changed to ");
                                String _description = depSource.getDescription();
                                _builder_2.append((Object)_description);
                                RuleProvider.this.logger.trace((Object)_builder_2);
                                RuleProvider.this.manipulation.addTo((EObject)depSource, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                            }
                            boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_to = depTransition.getTo()), (Object)depTarget);
                            if (_notEquals_1) {
                                StringConcatenation _builder_3 = new StringConcatenation();
                                _builder_3.append((Object)"Target state changed to ");
                                String _description_1 = depTarget.getDescription();
                                _builder_3.append((Object)_description_1);
                                RuleProvider.this.logger.trace((Object)_builder_3);
                                RuleProvider.this.manipulation.set((EObject)depTransition, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorTransition_To(), (Object)depTarget);
                            }
                            StringConcatenation _builder_4 = new StringConcatenation();
                            _builder_4.append((Object)"Updated mapped transition with ID: ");
                            _builder_4.append((Object)trId);
                            RuleProvider.this.logger.debug((Object)_builder_4);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<TransitionMatch> _function_2 = new IMatchProcessor<TransitionMatch>(){

                    public void process(TransitionMatch it) {
                        try {
                            Transition transition = it.getTransition();
                            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                            final Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
                            Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depTransitions.contains(it);
                                }
                            };
                            BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst(RuleProvider.this.cpsXformM2M.getDepBehaviorsStateAndTransitions(RuleProvider.this.engine).getAllValuesOfdepTransition(depApp.getBehavior(), null), (Functions.Function1)_function);
                            String trId = depTransition.getDescription();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Removing transition with ID: ");
                            _builder.append((Object)trId);
                            RuleProvider.this.logger.debug((Object)_builder);
                            RuleProvider.this.manipulation.set((EObject)depTransition, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorTransition_To(), null);
                            final Set<DeploymentElement> tempDepSources = RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                                public Boolean apply(BehaviorState it) {
                                    return tempDepSources.contains(it);
                                }
                            };
                            BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
                            if (depSource != null) {
                                RuleProvider.this.manipulation.remove((EObject)depSource, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                            }
                            RuleProvider.this.manipulation.remove((EObject)depApp.getBehavior(), (EStructuralFeature)RuleProvider.this.depPackage.getDeploymentBehavior_Transitions(), (Object)depTransition);
                            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOftrace(null, (Identifiable)transition, null));
                            RuleProvider.this.manipulation.remove((EObject)smTrace, (EStructuralFeature)RuleProvider.this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                            if (_isEmpty) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Removing empty trace");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.remove((EObject)RuleProvider.this.cps2dep, (EStructuralFeature)RuleProvider.this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                            }
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append((Object)"Removed transition with ID: ");
                            _builder_2.append((Object)trId);
                            RuleProvider.this.logger.debug((Object)_builder_2);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.transitionRule = this.factory.createRule().name("TransitionRule").precondition(TransitionMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function_1).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.transitionRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTriggerRule() {
        try {
            boolean _equals = Objects.equal(this.triggerRule, null);
            if (_equals) {
                IMatchProcessor<TriggerPairMatch> _function = new IMatchProcessor<TriggerPairMatch>(){

                    public void process(TriggerPairMatch it) {
                        try {
                            boolean _not;
                            final DeploymentApplication depAppTrigger = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTrigger()), DeploymentApplication.class));
                            final DeploymentApplication depAppTarget = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTarget()), DeploymentApplication.class));
                            Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depAppTrigger.getBehavior().getTransitions().contains((Object)it);
                                }
                            };
                            BehaviorTransition sendTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTrigger()), BehaviorTransition.class), (Functions.Function1)_function);
                            Functions.Function1<BehaviorTransition, Boolean> _function_1 = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depAppTarget.getBehavior().getTransitions().contains((Object)it);
                                }
                            };
                            BehaviorTransition waitTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTarget()), BehaviorTransition.class), (Functions.Function1)_function_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Mapping trigger between ");
                            String _description = sendTr.getDescription();
                            _builder.append((Object)_description);
                            _builder.append((Object)" and ");
                            String _description_1 = waitTr.getDescription();
                            _builder.append((Object)_description_1);
                            RuleProvider.this.logger.debug((Object)_builder);
                            boolean _contains = sendTr.getTrigger().contains((Object)waitTr);
                            boolean bl = _not = !_contains;
                            if (_not) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Adding new trigger");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.addTo((EObject)sendTr, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorTransition_Trigger(), (Object)waitTr);
                            }
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append((Object)"Mapped trigger between ");
                            String _description_2 = sendTr.getDescription();
                            _builder_2.append((Object)_description_2);
                            _builder_2.append((Object)" and ");
                            String _description_3 = waitTr.getDescription();
                            _builder_2.append((Object)_description_3);
                            RuleProvider.this.logger.debug((Object)_builder_2);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IMatchProcessor<TriggerPairMatch> _function_1 = new IMatchProcessor<TriggerPairMatch>(){

                    public void process(TriggerPairMatch it) {
                        try {
                            final DeploymentApplication depAppTrigger = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTrigger()), DeploymentApplication.class));
                            final DeploymentApplication depAppTarget = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTarget()), DeploymentApplication.class));
                            Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depAppTrigger.getBehavior().getTransitions().contains((Object)it);
                                }
                            };
                            BehaviorTransition sendTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTrigger()), BehaviorTransition.class), (Functions.Function1)_function);
                            Functions.Function1<BehaviorTransition, Boolean> _function_1 = new Functions.Function1<BehaviorTransition, Boolean>(){

                                public Boolean apply(BehaviorTransition it) {
                                    return depAppTarget.getBehavior().getTransitions().contains((Object)it);
                                }
                            };
                            BehaviorTransition waitTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(RuleProvider.this.cpsXformM2M.getCps2depTrace(RuleProvider.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTarget()), BehaviorTransition.class), (Functions.Function1)_function_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Removing trigger between ");
                            String _description = sendTr.getDescription();
                            _builder.append((Object)_description);
                            _builder.append((Object)" and ");
                            String _description_1 = waitTr.getDescription();
                            _builder.append((Object)_description_1);
                            RuleProvider.this.logger.debug((Object)_builder);
                            boolean _contains = sendTr.getTrigger().contains((Object)waitTr);
                            if (_contains) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Removing existing trigger");
                                RuleProvider.this.logger.trace((Object)_builder_1);
                                RuleProvider.this.manipulation.remove((EObject)sendTr, (EStructuralFeature)RuleProvider.this.depPackage.getBehaviorTransition_Trigger(), (Object)waitTr);
                            }
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append((Object)"Removed trigger between ");
                            String _description_2 = sendTr.getDescription();
                            _builder_2.append((Object)_description_2);
                            _builder_2.append((Object)" and ");
                            String _description_3 = waitTr.getDescription();
                            _builder_2.append((Object)_description_3);
                            RuleProvider.this.logger.debug((Object)_builder_2);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                this.triggerRule = this.factory.createRule().name("TriggerRule").precondition(TriggerPairMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function).action(CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function_1).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
            }
            return this.triggerRule;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

