/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.IQueryResultViewModelListener;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtext.xbase.lib.Conversions;

class QueryResultTreeContentProvider
implements ITreeContentProvider,
IQueryResultViewModelListener {
    protected TreeViewer viewer;
    protected QueryResultTreeInput input;
    protected AdapterFactoryContentProvider adapterFactoryContentProvider;

    public QueryResultTreeContentProvider() {
        AdapterFactoryContentProvider _adapterFactoryContentProvider;
        AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
        this.adapterFactoryContentProvider = _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof TreeViewer));
        this.viewer = (TreeViewer)viewer;
        if (oldInput instanceof QueryResultTreeInput) {
            ((QueryResultTreeInput)oldInput).removeListener(this);
        }
        if (newInput instanceof QueryResultTreeInput) {
            this.input = (QueryResultTreeInput)newInput;
            ((QueryResultTreeInput)newInput).addListener(this);
        } else if (newInput != null) {
            Class<?> _class = newInput.getClass();
            String _name = _class.getName();
            String _format = String.format("Invalid input type %s for List Viewer.", _name);
            throw new IllegalArgumentException(_format);
        }
    }

    public void dispose() {
        QueryResultTreeInput _input = this.input;
        if (_input != null) {
            _input.removeListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getChildrenInternal(parentElement);
    }

    protected Object[] _getChildrenInternal(QueryResultTreeInput inputElement) {
        Map<String, QueryResultTreeMatcher> _matchers = inputElement.getMatchers();
        return (Object[])Conversions.unwrapArray(_matchers.values(), Object.class);
    }

    protected Object[] _getChildrenInternal(QueryResultTreeMatcher inputElement) {
        boolean _tripleNotEquals;
        Exception _exception = inputElement.getException();
        boolean bl = _tripleNotEquals = _exception != null;
        if (_tripleNotEquals) {
            return null;
        }
        ViatraQueryMatcher _matcher = inputElement.getMatcher();
        IPatternMatch _filterMatch = inputElement.getFilterMatch();
        return (Object[])Conversions.unwrapArray((Object)_matcher.getAllMatches(_filterMatch), Object.class);
    }

    protected Object[] _getChildrenInternal(IPatternMatch inputElement) {
        boolean _not;
        List _parameterNames = inputElement.parameterNames();
        boolean _isEmpty = _parameterNames.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return inputElement.toArray();
        }
        return null;
    }

    protected Object[] _getChildrenInternal(Object inputElement) {
        return null;
    }

    public Object getParent(Object element) {
        return this.getParentInternal(element);
    }

    protected Object _getParentInternal(QueryResultTreeInput inputElement) {
        return null;
    }

    protected Object _getParentInternal(QueryResultTreeMatcher inputElement) {
        return inputElement.getParent();
    }

    protected Object _getParentInternal(IPatternMatch inputElement) {
        Map<String, QueryResultTreeMatcher> _matchers = this.input.getMatchers();
        IQuerySpecification _specification = inputElement.specification();
        String _fullyQualifiedName = _specification.getFullyQualifiedName();
        return _matchers.get(_fullyQualifiedName);
    }

    protected Object _getParentInternal(Object inputElement) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.hasChildrenInternal(element);
    }

    protected boolean _hasChildrenInternal(QueryResultTreeInput inputElement) {
        Map<String, QueryResultTreeMatcher> _matchers = inputElement.getMatchers();
        boolean _isEmpty = _matchers.isEmpty();
        return !_isEmpty;
    }

    protected boolean _hasChildrenInternal(QueryResultTreeMatcher inputElement) {
        IPatternMatch _filterMatch;
        boolean _tripleNotEquals;
        Exception _exception = inputElement.getException();
        boolean bl = _tripleNotEquals = _exception != null;
        if (_tripleNotEquals) {
            return false;
        }
        ViatraQueryMatcher _matcher = inputElement.getMatcher();
        int _countMatches = _matcher.countMatches(_filterMatch = inputElement.getFilterMatch());
        return _countMatches > 0;
    }

    protected boolean _hasChildrenInternal(IPatternMatch inputElement) {
        boolean _not;
        List _parameterNames = inputElement.parameterNames();
        boolean _isEmpty = _parameterNames.isEmpty();
        boolean bl = _not = !_isEmpty;
        return _not;
    }

    protected boolean _hasChildrenInternal(Object inputElement) {
        return false;
    }

    @Override
    public void matcherAdded(final QueryResultTreeMatcher matcher) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeInput _parent = matcher.getParent();
                    QueryResultTreeContentProvider.this.viewer.add((Object)_parent, (Object)matcher);
                }
            }
        };
        _display.asyncExec(_function);
    }

    @Override
    public void matcherFilterUpdated(final QueryResultTreeMatcher matcher) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeContentProvider.this.viewer.refresh((Object)matcher);
                }
            }
        };
        _display.asyncExec(_function);
    }

    @Override
    public void matcherRemoved(final QueryResultTreeMatcher matcher) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeContentProvider.this.viewer.remove((Object)matcher);
                }
            }
        };
        _display.asyncExec(_function);
    }

    @Override
    public void matchAdded(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeContentProvider.this.viewer.add((Object)matcher, (Object)match);
                    QueryResultTreeContentProvider.this.viewer.update((Object)matcher, null);
                }
            }
        };
        _display.asyncExec(_function);
    }

    @Override
    public void matchUpdated(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeContentProvider.this.viewer.refresh((Object)match);
                    QueryResultTreeContentProvider.this.viewer.update((Object)matcher, null);
                }
            }
        };
        _display.asyncExec(_function);
    }

    @Override
    public void matchRemoved(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
        Tree _tree = this.viewer.getTree();
        Display _display = _tree.getDisplay();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _not;
                Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
                boolean _isDisposed = _tree.isDisposed();
                boolean bl = _not = !_isDisposed;
                if (_not) {
                    QueryResultTreeContentProvider.this.viewer.remove((Object)match);
                    QueryResultTreeContentProvider.this.viewer.update((Object)matcher, null);
                }
            }
        };
        _display.asyncExec(_function);
    }

    public Object[] getChildrenInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._getChildrenInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._getChildrenInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._getChildrenInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._getChildrenInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }

    public Object getParentInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._getParentInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._getParentInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._getParentInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._getParentInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }

    public boolean hasChildrenInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._hasChildrenInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._hasChildrenInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._hasChildrenInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._hasChildrenInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }
}

