/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import com.google.common.base.Preconditions;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.AbstractRuleInstanceBuilder;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventHandler;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventRealm;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSource;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSourceSpecification;

public class ViatraQueryRuleInstanceBuilder<Match extends IPatternMatch>
extends AbstractRuleInstanceBuilder<Match> {
    private ViatraQueryEventRealm realm;
    private ViatraQueryEventSourceSpecification<Match> sourceSpecification;

    @Override
    public void prepareRuleInstance(RuleInstance<Match> ruleInstance, EventFilter<? super Match> filter) {
        try {
            Preconditions.checkArgument((ruleInstance != null ? 1 : 0) != 0, (Object)"Cannot prepare null rule instance!");
            ViatraQueryEventSource<Match> source = this.realm.createSource(this.sourceSpecification);
            ViatraQueryEventHandler<Match> handler = new ViatraQueryEventHandler<Match>(source, filter, ruleInstance);
            handler.prepareEventHandler();
        }
        catch (ViatraQueryException e) {
            throw new RuntimeException("Could not create matcher for event source definition " + this.sourceSpecification + " in realm " + this.realm, e);
        }
    }

    protected ViatraQueryRuleInstanceBuilder(ViatraQueryEventRealm realm, ViatraQueryEventSourceSpecification<Match> sourceSpecification) {
        Preconditions.checkArgument((realm != null ? 1 : 0) != 0, (Object)"Cannot create builder with null realm!");
        Preconditions.checkArgument((sourceSpecification != null ? 1 : 0) != 0, (Object)"Cannot create builder with null realm!");
        this.realm = realm;
        this.sourceSpecification = sourceSpecification;
    }
}

