/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.Event;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.api.event.adapter.EventHandlerAdapter;
import org.eclipse.viatra.transformation.evm.api.event.adapter.EventProcessorAdapter;
import org.eclipse.viatra.transformation.evm.notification.AttributeMonitor;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDEventTypeEnum;
import org.eclipse.viatra.transformation.evm.specific.event.LightweightAttributeMonitor;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryEventSource;

public class ViatraQueryEventHandler<Match extends IPatternMatch>
extends EventHandlerAdapter<Match> {
    private AttributeMonitor<Match> attributeMonitor;
    private UnregisterMonitorActivationNotificationListener unregisterListener;

    protected ViatraQueryEventHandler(ViatraQueryEventSource<Match> source, EventFilter<? super Match> filter, RuleInstance<Match> instance) {
        super(source, filter, instance);
    }

    protected AttributeMonitor<Match> prepareAttributeMonitor() {
        LightweightAttributeMonitor monitor = null;
        ViatraQueryEventSource eventSource = (ViatraQueryEventSource)this.getSource();
        try {
            monitor = new LightweightAttributeMonitor(eventSource.getMatcher().getEngine().getBaseIndex());
        }
        catch (ViatraQueryException e) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)"Error happened while accessing base index", (Throwable)e);
        }
        return monitor;
    }

    @Override
    protected void prepareEventHandler() {
        super.prepareEventHandler();
        this.attributeMonitor = (AttributeMonitor)Preconditions.checkNotNull(this.prepareAttributeMonitor(), (Object)"Prepared attribute monitor is null!");
        ViatraQueryEventSource eventSource = (ViatraQueryEventSource)this.getSource();
        eventSource.addHandler(this);
        this.attributeMonitor.addAttributeMonitorListener(eventSource.getAttributeMonitorListener());
        this.unregisterListener = (UnregisterMonitorActivationNotificationListener)Preconditions.checkNotNull((Object)this.prepareActivationNotificationListener(), (Object)"Prepared activation notification listener is null!");
        this.getInstance().addActivationNotificationListener(this.unregisterListener, false);
    }

    protected UnregisterMonitorActivationNotificationListener prepareActivationNotificationListener() {
        return new UnregisterMonitorActivationNotificationListener();
    }

    @Override
    protected Map<EventType, EventProcessorAdapter<Match>> prepareEventProcessors() {
        HashMap processors = Maps.newHashMap();
        processors.put(CRUDEventTypeEnum.CREATED, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, CRUDEventTypeEnum.CREATED);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                IPatternMatch eventAtom = (IPatternMatch)event.getEventAtom();
                Activation<IPatternMatch> activation = this.getInstance().createActivation(eventAtom);
                if (this.getInstance().getLifeCycle().containsTo(CRUDActivationStateEnum.UPDATED)) {
                    ViatraQueryEventHandler.this.attributeMonitor.registerFor(eventAtom);
                }
                this.getInstance().activationStateTransition(activation, CRUDEventTypeEnum.CREATED);
            }
        });
        processors.put(CRUDEventTypeEnum.UPDATED, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, CRUDEventTypeEnum.UPDATED);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                Preconditions.checkState((boolean)false, (String)"Atom %s updated without existing activation in rule instance %s!", (Object[])new Object[]{event.getEventAtom(), this});
            }
        });
        processors.put(CRUDEventTypeEnum.DELETED, new EventProcessorAdapter<Match>(this.getInstance()){

            @Override
            protected void activationExists(Event<Match> event, Activation<Match> activation) {
                this.getInstance().activationStateTransition(activation, CRUDEventTypeEnum.DELETED);
            }

            @Override
            protected void activationMissing(Event<Match> event) {
                Preconditions.checkState((boolean)false, (String)"Match %s disappeared without existing activation in rule instance %s!", (Object[])new Object[]{event.getEventAtom(), this});
            }
        });
        return processors;
    }

    @Override
    public void dispose() {
        this.getInstance().removeActivationNotificationListener(this.unregisterListener);
        ((ViatraQueryEventSource)this.getSource()).removeHandler(this);
        this.attributeMonitor.dispose();
    }

    private final class UnregisterMonitorActivationNotificationListener
    implements IActivationNotificationListener {
        private UnregisterMonitorActivationNotificationListener() {
        }

        @Override
        public void activationRemoved(Activation<?> activation, ActivationState oldState) {
            ViatraQueryEventHandler.this.attributeMonitor.unregisterFor((IPatternMatch)activation.getAtom());
        }

        @Override
        public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
        }

        @Override
        public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        }
    }
}

