/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.VariableDeferredPConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class ExportedParameter
extends VariableDeferredPConstraint {
    PVariable parameterVariable;
    final String parameterName;
    final PParameter patternParameter;

    public ExportedParameter(PBody pBody, PVariable parameterVariable, PParameter patternParameter) {
        super(pBody, Collections.singleton(parameterVariable));
        this.parameterVariable = parameterVariable;
        this.patternParameter = patternParameter;
        this.parameterName = patternParameter.getName();
    }

    @Deprecated
    public ExportedParameter(PBody pBody, PVariable parameterVariable, String parameterName) {
        super(pBody, Collections.singleton(parameterVariable));
        this.parameterVariable = parameterVariable;
        this.parameterName = parameterVariable.getName();
        this.patternParameter = null;
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.parameterVariable)) {
            this.parameterVariable = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        String varName = this.parameterVariable.getName();
        return this.parameterName.equals(varName) ? this.parameterName : String.valueOf(this.parameterName) + "(" + varName + ")";
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public PVariable getParameterVariable() {
        return this.parameterVariable;
    }

    public PParameter getPatternParameter() {
        if (this.patternParameter == null) {
            PQuery query = this.pBody.getPattern();
            Integer index = query.getPositionOfParameter(this.parameterName);
            if (index == null) {
                throw new IllegalStateException(String.format("Pattern %s does not have a parameter named %s", query.getFullyQualifiedName(), this.parameterName));
            }
            return query.getParameters().get(index);
        }
        return this.patternParameter;
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return Collections.singleton(this.parameterVariable);
    }

    @Override
    public void checkSanity() throws QueryProcessingException {
        super.checkSanity();
        if (!this.parameterVariable.isDeducable()) {
            String[] args = new String[]{this.parameterName};
            String msg = "Impossible to match pattern: exported pattern variable {1} can not be determined based on the pattern constraints. HINT: certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters.";
            String shortMsg = "Could not deduce value of parameter";
            throw new QueryProcessingException(msg, args, shortMsg, null);
        }
    }
}

