/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;

public class ExtendToEStructuralFeatureSource
extends ExtendOperation
implements IIteratingSearchOperation {
    private int targetPosition;
    private EStructuralFeature feature;
    private final IInputKey type;
    private VolatileMaskedTuple maskedTuple;
    private static final TupleMask indexerMask = TupleMask.fromSelectedIndices((int)2, (int[])new int[]{1});

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature, TupleMask mask) {
        super(sourcePosition);
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.type = new EStructuralFeatureInstancesKey(feature);
        this.maskedTuple = new VolatileMaskedTuple(mask);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((ITuple)frame);
        Iterable values = context.getRuntimeContext().enumerateValues(this.type, indexerMask, (ITuple)this.maskedTuple);
        this.it = Iterables.filter((Iterable)values, EObject.class).iterator();
    }

    public String toString() {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + this.position + ", +" + this.targetPosition + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position, this.targetPosition);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }
}

