/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;

public abstract class CompoundDeclaration
extends Declaration {
    private static final int BIT_MASK = 3;
    private static final int BITS_PER_BYTE = 8;

    public abstract IDeclaration getElementType();

    @Override
    public long getAlignment() {
        return this.getElementType().getAlignment();
    }

    public boolean isString() {
        IDeclaration elementType = this.getElementType();
        if (elementType instanceof IntegerDeclaration) {
            IntegerDeclaration elemInt = (IntegerDeclaration)elementType;
            return elemInt.isCharacter();
        }
        return false;
    }

    public boolean isAlignedBytes() {
        IDeclaration elementType = this.getElementType();
        if (elementType instanceof IntegerDeclaration) {
            IntegerDeclaration elemInt = (IntegerDeclaration)elementType;
            return elemInt.getLength() == 8 && (this.getAlignment() & 3L) == 0L;
        }
        return false;
    }
}

