/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.Spawner;

public class ProcessFactory {
    private static ProcessFactory instance;
    private boolean hasSpawner = false;
    private Runtime runtime;
    private static final String FLATPAK_CMD = "flatpak-spawn --host --watch-bus ";

    private ProcessFactory() {
        String OS = System.getProperty("os.name").toLowerCase();
        this.runtime = Runtime.getRuntime();
        try {
            if (OS != null && OS.equals("windows 98")) {
                this.hasSpawner = false;
            } else {
                System.loadLibrary("spawner");
                this.hasSpawner = true;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e) {
            CNativePlugin.log(e.getMessage());
        }
    }

    public static ProcessFactory getFactory() {
        if (instance == null) {
            instance = new ProcessFactory();
        }
        return instance;
    }

    public Process exec(String cmd) throws IOException {
        cmd = this.modifyCmdIfFlatpak(cmd);
        if (this.hasSpawner) {
            return new Spawner(cmd);
        }
        return this.runtime.exec(cmd);
    }

    public Process exec(String[] cmdarray) throws IOException {
        cmdarray = this.modifyCmdArrayIfFlatpak(cmdarray);
        if (this.hasSpawner) {
            return new Spawner(cmdarray);
        }
        return this.runtime.exec(cmdarray);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        cmdarray = this.modifyCmdArrayIfFlatpak(cmdarray);
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp);
        }
        return this.runtime.exec(cmdarray, envp);
    }

    public Process exec(String cmd, String[] envp) throws IOException {
        cmd = this.modifyCmdIfFlatpak(cmd);
        if (this.hasSpawner) {
            return new Spawner(cmd, envp);
        }
        return this.runtime.exec(cmd, envp);
    }

    public Process exec(String cmd, String[] envp, File dir) throws IOException {
        cmd = this.modifyCmdIfFlatpak(cmd);
        if (this.hasSpawner) {
            return new Spawner(cmd, envp, dir);
        }
        return this.runtime.exec(cmd, envp, dir);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        cmdarray = this.modifyCmdArrayIfFlatpak(cmdarray);
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp, dir);
        }
        return this.runtime.exec(cmdarray, envp, dir);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, PTY pty) throws IOException {
        cmdarray = this.modifyCmdArrayIfFlatpak(cmdarray);
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp, dir, pty);
        }
        throw new UnsupportedOperationException(Messages.Util_exception_cannotCreatePty);
    }

    private String modifyCmdIfFlatpak(String cmd) {
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            cmd = FLATPAK_CMD + cmd;
        }
        return cmd;
    }

    private String[] modifyCmdArrayIfFlatpak(String[] cmdarray) {
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            String[] newArray = new String[cmdarray.length + 3];
            System.arraycopy(cmdarray, 0, newArray, 3, cmdarray.length);
            newArray[0] = "flatpak-spawn";
            newArray[1] = "--host";
            newArray[2] = "--watch-bus";
            cmdarray = newArray;
        }
        return cmdarray;
    }
}

