/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

public enum IoOperationType {
    WRITE,
    READ,
    FLUSH,
    OTHER;

    private static final int RWBS_FLAG_WRITE = 1;
    private static final int RWBS_FLAG_READ = 4;
    private static final int RWBS_FLAG_RAHEAD = 8;
    private static final int RWBS_FLAG_FLUSH = 256;
    private static final int RWBS_FLAG_PREFLUSH = 1024;

    public static IoOperationType getType(int rwbs) {
        if ((rwbs & 1) != 0) {
            return WRITE;
        }
        if ((rwbs & 4) != 0 || (rwbs & 8) != 0) {
            return READ;
        }
        if ((rwbs & 0x100) != 0 || (rwbs & 0x400) != 0) {
            return FLUSH;
        }
        return OTHER;
    }

    public static IoOperationType fromNumber(Integer value) {
        if (value.intValue() == WRITE.ordinal()) {
            return WRITE;
        }
        if (value.intValue() == READ.ordinal()) {
            return READ;
        }
        if (value.intValue() == FLUSH.ordinal()) {
            return FLUSH;
        }
        return OTHER;
    }
}

