/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.common.uriresolver.internal.URI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.DelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.RewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.SuffixEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CatalogReader {
    public static void read(Catalog xmlCatalog, InputStream input) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(input), (DefaultHandler)new CatalogContentHandler(xmlCatalog));
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        catch (SAXException e) {
            Logger.logException(e);
        }
    }

    protected static class CatalogContentHandler
    extends DefaultHandler {
        protected Catalog catalog;
        protected Stack baseURIStack = new Stack();

        public CatalogContentHandler(Catalog xmlCatalog) {
            this.catalog = xmlCatalog;
            String base = xmlCatalog.getBase();
            if (base == null || base == "") {
                base = xmlCatalog.getLocation();
            }
            this.baseURIStack.push(base);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String base = attributes.getValue("xml:base");
            if (base != null && !base.equals("")) {
                if (URI.createURI((String)base).isRelative()) {
                    base = URI.resolveRelativeURI((String)base, (String)this.baseURIStack.peek().toString());
                }
                this.baseURIStack.push(URIHelper.ensureURIProtocolFormat((String)base));
            } else {
                this.baseURIStack.push(this.baseURIStack.peek());
            }
            if (localName.equals("UserEntry")) {
                String typeName = attributes.getValue("", "TYPE");
                boolean isSystem = false;
                if (typeName != null) {
                    isSystem = typeName.compareToIgnoreCase("SYSTEM") == 0;
                }
                CatalogEntry catalogEntry = new CatalogEntry(isSystem ? 3 : 2);
                catalogEntry.setKey(attributes.getValue("", "ID"));
                String entryUri = attributes.getValue("", "URI");
                catalogEntry.setURI(this.resolveRelative(entryUri));
                String webURL = attributes.getValue("", "WEB_URL");
                if (webURL != null) {
                    catalogEntry.setAttributeValue("webURL", webURL);
                }
                this.catalog.addCatalogElement(catalogEntry);
                return;
            }
            ICatalogElement catalogElement = null;
            if ("public".equals(localName)) {
                catalogElement = this.createEntry(attributes, 2, "publicId");
            } else if ("system".equals(localName)) {
                catalogElement = this.createEntry(attributes, 3, "systemId");
            } else if ("uri".equals(localName)) {
                catalogElement = this.createEntry(attributes, 4, "name");
            } else if ("rewriteSystem".equals(localName)) {
                catalogElement = this.createRewrite(attributes, 21, "systemIdStartString");
            } else if ("rewriteURI".equals(localName)) {
                catalogElement = this.createRewrite(attributes, 22, "uriStartString");
            } else if ("delegatePublic".equals(localName)) {
                catalogElement = this.createDelegate(attributes, 31, "publicIdStartString");
            } else if ("delegateSystem".equals(localName)) {
                catalogElement = this.createDelegate(attributes, 32, "systemIdStartString");
            } else if ("delegateURI".equals(localName)) {
                catalogElement = this.createDelegate(attributes, 33, "uriStartString");
            } else if ("systemSuffix".equals(localName)) {
                catalogElement = this.createSuffix(attributes, 41, "systemIdSuffix");
            } else if ("uriSuffix".equals(localName)) {
                catalogElement = this.createSuffix(attributes, 42, "uriSuffix");
            } else if ("nextCatalog".equals(localName)) {
                catalogElement = this.createNextCatalog(attributes);
            }
            if (catalogElement == null) {
                return;
            }
            String attrId = attributes.getValue("", "id");
            if (attrId != null && !"".equals(attrId)) {
                catalogElement.setId(attrId);
            }
            int j = 0;
            while (j < attributes.getLength()) {
                String attrValue;
                String attrName = attributes.getLocalName(j);
                if (!(attrName.equals("uri") || attrName.equals("name") || attrName.equals("publicId") || attrName.equals("systemId") || attrName.equals("catalog") || attrName.equals("id") || attrName.equals("xml:base") || (attrValue = attributes.getValue(attrName)) == null || attrValue.equals(""))) {
                    catalogElement.setAttributeValue(attrName, attrValue);
                }
                ++j;
            }
            this.catalog.addCatalogElement(catalogElement);
        }

        private ICatalogElement createNextCatalog(Attributes attributes) {
            String location = attributes.getValue("", "catalog");
            NextCatalog delegate = new NextCatalog();
            delegate.setBase((String)this.baseURIStack.peek());
            delegate.setCatalogLocation(location);
            return delegate;
        }

        private ICatalogEntry createEntry(Attributes attributes, int entryType, String keyAttributeName) {
            String key = attributes.getValue("", keyAttributeName);
            if (key == null || key.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_key_not_set);
                return null;
            }
            String entryURI = attributes.getValue("", "uri");
            if (entryURI == null || entryURI.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_uri_not_set);
                return null;
            }
            CatalogEntry entry = new CatalogEntry(entryType);
            entry.setKey(key);
            entry.setURI(this.resolveRelative(entryURI));
            return entry;
        }

        private IRewriteEntry createRewrite(Attributes attributes, int entryType, String prefixStringName) {
            String startString = attributes.getValue("", prefixStringName);
            if (startString == null || startString.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_rewrite_startString_not_set);
                return null;
            }
            String prefix = attributes.getValue("", "rewritePrefix");
            if (prefix == null || prefix.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_rewrite_prefix_not_set);
                return null;
            }
            RewriteEntry entry = new RewriteEntry(entryType);
            entry.setStartString(startString);
            entry.setRewritePrefix(this.resolveRelative(prefix));
            return entry;
        }

        private IDelegateCatalog createDelegate(Attributes attributes, int entryType, String startStringAttrName) {
            String startString = attributes.getValue("", startStringAttrName);
            if (startString == null || startString.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_delegate_prefix_not_set);
                return null;
            }
            String catalogUri = attributes.getValue("", "catalog");
            if (catalogUri == null || catalogUri.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_delegate_prefix_not_set);
                return null;
            }
            DelegateCatalog entry = new DelegateCatalog(entryType);
            entry.setStartString(startString);
            entry.setCatalogLocation(catalogUri);
            return entry;
        }

        private ISuffixEntry createSuffix(Attributes attributes, int entryType, String suffixAttrName) {
            String suffix = attributes.getValue("", suffixAttrName);
            if (suffix == null || suffix.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_suffix_string_not_set);
                return null;
            }
            String uri = attributes.getValue("", "uri");
            if (uri == null || uri.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_suffix_uri_not_set);
                return null;
            }
            SuffixEntry entry = new SuffixEntry(entryType);
            entry.setSuffix(suffix);
            entry.setURI(this.resolveRelative(uri));
            return entry;
        }

        private String resolveRelative(String entryURI) {
            if (URI.createURI((String)entryURI).isRelative()) {
                entryURI = URI.resolveRelativeURI((String)entryURI, (String)this.baseURIStack.peek().toString());
            }
            return URIHelper.ensureURIProtocolFormat((String)entryURI);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.baseURIStack.size() > 0) {
                this.baseURIStack.pop();
            }
        }
    }

    static interface CompatabilityConstants {
        public static final String TAG_ID_XML_CATALOG_SETTINGS = "XMLCatalogSettings";
        public static final String TAG_ID_USER_ENTRIES = "UserEntries";
        public static final String TAG_USER_ENTRY = "UserEntry";
        public static final String ATT_TYPE = "TYPE";
        public static final String ATT_ID = "ID";
        public static final String ATT_URI = "URI";
        public static final String ATT_WEB_URL = "WEB_URL";
    }
}

