/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.callstack;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.base.FlameWithKernelPalette;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.callstack.CallstackXmlAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class XmlCallstackTest
extends CallStackTestBase2 {
    private static final @NonNull String XML_MODULE_ID = "callstack.analysis";
    private static final String XML_FILE_NAME = "test_callstack.xml";
    private static final Path CALLSTACK_XML_PATH = new Path("test_xml_files/test_valid/test_callstack.xml");
    private CallstackXmlAnalysis fXmlModule;

    public void setUp() {
        IPath absoluteFilePath = Activator.getAbsolutePath(CALLSTACK_XML_PATH);
        File file = absoluteFilePath.toFile();
        IStatus xmlFile = XmlUtils.addXmlFile((File)file);
        Assert.assertTrue((boolean)xmlFile.isOK());
        XmlAnalysisModuleSource.notifyModuleChange();
        super.setUp();
        ITmfTrace trace = this.getTrace();
        CallstackXmlAnalysis module = (CallstackXmlAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallstackXmlAnalysis.class, (String)XML_MODULE_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        this.fXmlModule = module;
    }

    public void tearDown() {
        super.tearDown();
        XmlUtils.deleteFiles(Collections.singleton(XML_FILE_NAME));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCallstackWeightedTree() {
        CallstackXmlAnalysis xmlModule = this.fXmlModule;
        Assert.assertNotNull((Object)xmlModule);
        IWeightedTreeProvider.MetricType weightType = xmlModule.getWeightType();
        Assert.assertEquals((Object)IWeightedTreeProvider.DataType.NANOSECONDS, (Object)weightType.getDataType());
        @NonNull List additionalMetrics = xmlModule.getAdditionalMetrics();
        Assert.assertFalse((boolean)additionalMetrics.isEmpty());
        IDataPalette palette = xmlModule.getPalette();
        Assert.assertEquals((Object)FlameWithKernelPalette.getInstance(), (Object)palette);
    }
}

