/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DecimalWithUnitPrefixFormat;
import org.eclipse.tracecompass.common.core.tests.format.FormatTestBase;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecimalWithUnitPrefixFormatTest
extends FormatTestBase {
    private static final @NonNull String UNITS = "rabbit";
    private static final @NonNull Format FORMAT = new DecimalWithUnitPrefixFormat("rabbit");

    public DecimalWithUnitPrefixFormatTest(@Nullable Number numValue, @NonNull String stringValue, @Nullable Number parseValue, int parseIndex) {
        super(numValue, stringValue, parseValue, parseIndex);
    }

    protected static Collection<Object[]> getCommonParameters() {
        return Arrays.asList({0, "0 rabbit", 0L, -1}, {3, "3 rabbit", 3L, -1}, {975, "975 rabbit", 975L, -1}, {1000, "1 krabbit", 1000L, -1}, {1000000, "1 Mrabbit", 1000000L, -1}, {1000000000L, "1 Grabbit", 1000000000L, -1}, {1000000000000L, "1 Trabbit", 1000000000000L, -1}, {4000, "4 krabbit", 4000L, -1}, {-4000, "-4 krabbit", -4000L, -1}, {4000L, "4 krabbit", 4000L, -1}, {4000.0, "4 krabbit", 4000L, -1}, {12345678, "12.346 Mrabbit", 1.2346E7, -1}, {Integer.MAX_VALUE, "2.147 Grabbit", 2.147E9, -1}, {Integer.MIN_VALUE, "-2.147 Grabbit", -2.147E9, -1}, {Long.MAX_VALUE, "9223372.037 Trabbit", 9.223372037E18, -1}, {9.8765432123456E7, "98.765 Mrabbit", 9.8765E7, -1}, {-9.8765432123456E7, "-98.765 Mrabbit", -9.8765E7, -1}, {555555555555L, "555.556 Grabbit", 5.55556E11, -1}, {555555555555555L, "555.556 Trabbit", 5.55556E14, -1}, {100100000, "100.1 Mrabbit", 1.001E8, -1}, {0.1, "100 mrabbit", 0.1, -1}, {0.001, "1 mrabbit", 0.001, -1}, {1.0E-6, "1 \u00b5rabbit", 1.0E-6, -1}, {1.0E-9, "1 nrabbit", 1.0E-9, -1}, {1.0E-12, "1 prabbit", 1.0E-12, -1}, {-0.04, "-40 mrabbit", -0.04, -1}, {0.002, "2 mrabbit", 0.002, -1}, {0.0555, "55.5 mrabbit", 0.0555, -1}, {4.928373928E-4, "492.837 \u00b5rabbit", 4.92837E-4, -1}, {2.51E-7, "251 nrabbit", 2.51E-7, -1}, {4.3E-11, "43 prabbit", 4.3E-11, -1}, {4.5643E-8, "45.643 nrabbit", 4.5643E-8, -1});
    }

    @Parameterized.Parameters(name="{index}: {0} - {1}")
    public static Iterable<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(DecimalWithUnitPrefixFormatTest.getCommonParameters());
        Object[][] objectArrayArray = new Object[6][];
        Object[] objectArray = new Object[4];
        objectArray[1] = "1234 TPotato";
        objectArray[2] = 1234L;
        objectArray[3] = 4;
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[4];
        objectArray2[1] = ".0001 Mrabbit";
        objectArray2[2] = 100.0;
        objectArray2[3] = -1;
        objectArrayArray[1] = objectArray2;
        Object[] objectArray3 = new Object[4];
        objectArray3[1] = "1krabbit";
        objectArray3[2] = 1000L;
        objectArray3[3] = -1;
        objectArrayArray[2] = objectArray3;
        Object[] objectArray4 = new Object[4];
        objectArray4[1] = "1krabbit   ";
        objectArray4[2] = 1000L;
        objectArray4[3] = 8;
        objectArrayArray[3] = objectArray4;
        Object[] objectArray5 = new Object[4];
        objectArray5[1] = "1 Krabbit   ";
        objectArray5[2] = 1000L;
        objectArray5[3] = 9;
        objectArrayArray[4] = objectArray5;
        Object[] objectArray6 = new Object[4];
        objectArray6[1] = "1krabbit  potato";
        objectArray6[2] = 1000L;
        objectArray6[3] = 8;
        objectArrayArray[5] = objectArray6;
        List newParameters = Arrays.asList(objectArrayArray);
        parameters.addAll(newParameters);
        return parameters;
    }

    @Override
    protected Format getFormatter() {
        return FORMAT;
    }
}

