/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageElement;

public class PageExtensionManager {
    public static final String POINT_WIZARD_PAGE_GROUP = "wizardPageGroup";
    public static final String ELEMENT_WIZARD_PAGE = "wizardPage";
    private String wizardID;
    private DMWizardPageElement[] elements;

    public PageExtensionManager(DataModelWizard wizard) {
        this.wizardID = wizard.getWizardID();
        this.loadElements();
    }

    public void createAdditionalControls(Composite parent, IDataModel model, String pageName) {
        int i = 0;
        while (i < this.elements.length) {
            DMWizardPageElement element = this.elements[i];
            if (this.wizardID.equals(element.getWizardID())) {
                element.createAdditionalControls(parent, model, pageName);
            }
            ++i;
        }
    }

    private void loadElements() {
        ArrayList<DMWizardPageElement> result = new ArrayList<DMWizardPageElement>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.common.frameworks.ui", POINT_WIZARD_PAGE_GROUP);
        IConfigurationElement[] allElements = point.getConfigurationElements();
        int i = 0;
        while (i < allElements.length) {
            IConfigurationElement element = allElements[i];
            if (ELEMENT_WIZARD_PAGE.equals(element.getName())) {
                result.add(new DMWizardPageElement(element));
            }
            ++i;
        }
        this.elements = result.toArray(new DMWizardPageElement[0]);
    }
}

