/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.osgi.framework.Bundle;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=SWTBotJunit4ClassRunner.class)
public class AddProjectNatureTest {
    private static final String SOME_PROJECT_NAME = "SomeProject";
    private static final String SOME_PROJECT_SHADOW_NAME = ".tracecompass-SomeProject";
    private static final String TRACE_NAME = "syslog_collapse";
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String PROJECT_EXPLORER_TITLE = "Project Explorer";
    private static final String CONTEXT_MENU_CONFIGURE = "Configure";
    private static final String CONTEXT_MENU_CONFIGURE_TRACING_NATURE = "Configure or convert to Tracing Project";
    private static final String TRACING_PROJECT_ROOT_NAME = "Trace Compass";
    private static final String TRACES_FOLDER_NAME = "Traces";
    private static final String EXPERIMENTS_FOLDER_NAME = "Experiments";
    private static final String FIRST_EVENT_TIME = "Jan 1 01:01:01";
    private static final String CUSTOMIZE_VIEW_MENU_ITEM_4_6 = "Customize View...";
    private static final String CUSTOMIZE_VIEW_DIALOG_TITLE_4_6 = "Available Customizations";
    private static final String CUSTOMIZE_VIEW_MENU_ITEM_4_7 = "Filters and Customization...";
    private static final String CUSTOMIZE_VIEW_DIALOG_TITLE_4_7 = "Filters and Customization";
    private static final String CUSTOMIZE_VIEW_RESOURCES_FILTER = ".* resources";
    private static final String CUSTOMIZE_VIEW_SHADOW_FILTER = "Trace Compass Shadow Projects";
    private static final String OK_BUTTON = "OK";
    private static IWorkspaceRoot fWorkspaceRoot;
    private static IProject fSomeProject;
    private static File fTestFile;
    private static SWTWorkbenchBot fBot;

    static {
        fTestFile = null;
    }

    @BeforeClass
    public static void init() throws Exception {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        fWorkspaceRoot = workspace.getRoot();
        fSomeProject = fWorkspaceRoot.getProject(SOME_PROJECT_NAME);
        fSomeProject.create((IProgressMonitor)progressMonitor);
        fSomeProject.open((IProgressMonitor)progressMonitor);
        IProjectDescription description = fSomeProject.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature"});
        fSomeProject.setDescription(description, null);
        fSomeProject.open((IProgressMonitor)progressMonitor);
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "MMM d HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.locale", Locale.US.toLanguageTag());
        TmfTimestampFormat.updateDefaultFormats();
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject(SOME_PROJECT_NAME, fBot);
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "SSS SSS SSS");
        TmfTimestampFormat.updateDefaultFormats();
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeSecondaryShells(fBot);
    }

    @Test
    public void testConfigureTracingNature() {
        SWTBotTreeItem projectItem = SWTBotUtils.selectProject(fBot, SOME_PROJECT_NAME);
        projectItem.contextMenu().menu(new String[]{CONTEXT_MENU_CONFIGURE, CONTEXT_MENU_CONFIGURE_TRACING_NATURE}).click();
        WaitUtils.waitForJobs();
        SWTBotTreeItem projectRoot = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, projectItem, TRACING_PROJECT_ROOT_NAME);
        Assert.assertEquals((Object)TRACING_PROJECT_ROOT_NAME, (Object)projectRoot.getText());
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, projectRoot, TRACES_FOLDER_NAME);
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, projectRoot, EXPERIMENTS_FOLDER_NAME);
        SWTBotUtils.openTrace(SOME_PROJECT_NAME, fTestFile.getAbsolutePath(), TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        SWTBotTable tableBot = editorBot.bot().table();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(tableBot, FIRST_EVENT_TIME, 1, 1));
        Assert.assertEquals((String)"Timestamp", (Object)FIRST_EVENT_TIME, (Object)tableBot.cell(1, 1));
        fBot.closeAllEditors();
    }

    @Test
    public void testViewerFilter() {
        SWTBotTreeItem[] items;
        AddProjectNatureTest.toggleFilters(false);
        SWTBotTreeItem shadowProject = SWTBotUtils.selectProject(fBot, SOME_PROJECT_SHADOW_NAME);
        Assert.assertEquals((Object)SOME_PROJECT_SHADOW_NAME, (Object)shadowProject.getText());
        SWTBotTreeItem tracesItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, shadowProject, TRACES_FOLDER_NAME);
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, tracesItem, TRACE_NAME);
        Assert.assertEquals((Object)TRACE_NAME, (Object)traceItem.getText());
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, shadowProject, EXPERIMENTS_FOLDER_NAME);
        AddProjectNatureTest.toggleFilters(true);
        SWTBotView viewBot = fBot.viewByTitle(PROJECT_EXPLORER_TITLE);
        viewBot.setFocus();
        SWTBot projectExplorerBot = viewBot.bot();
        SWTBotTree tree = projectExplorerBot.tree();
        SWTBotTreeItem[] sWTBotTreeItemArray = items = tree.getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem swtBotTreeItem = sWTBotTreeItemArray[n2];
            Assert.assertNotEquals((Object)SOME_PROJECT_SHADOW_NAME, (Object)swtBotTreeItem.getText());
            ++n2;
        }
    }

    private static void toggleFilters(boolean checked) {
        SWTBotView viewBot = fBot.viewByTitle(PROJECT_EXPLORER_TITLE);
        viewBot.setFocus();
        SWTBotRootMenu viewMenu = viewBot.viewMenu();
        String title = CUSTOMIZE_VIEW_DIALOG_TITLE_4_7;
        try {
            viewMenu.menu(new String[]{CUSTOMIZE_VIEW_MENU_ITEM_4_7}).click();
        }
        catch (WidgetNotFoundException e) {
            viewMenu.menu(new String[]{CUSTOMIZE_VIEW_MENU_ITEM_4_6}).click();
            title = CUSTOMIZE_VIEW_DIALOG_TITLE_4_6;
        }
        SWTBotShell shell = fBot.shell(title).activate();
        shell.bot().cTabItem(0).activate();
        SWTBotTable table = shell.bot().table();
        SWTBotTableItem item = table.getTableItem(CUSTOMIZE_VIEW_RESOURCES_FILTER);
        item.select();
        if (checked != item.isChecked()) {
            item.toggleCheck();
        }
        item = table.getTableItem(CUSTOMIZE_VIEW_SHADOW_FILTER);
        item.select();
        if (checked != item.isChecked()) {
            item.toggleCheck();
        }
        shell.bot().button(OK_BUTTON).click();
    }
}

