/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.ipv6;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv6.IPv6Endpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ipv6.IPv6Packet;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class IPv6PacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = new LinkedHashMap<String, String>();
    private static final String EXPECTED_TOSTRING;
    private ByteBuffer fPacket;

    static {
        EXPECTED_FIELDS.put("Version", "6");
        EXPECTED_FIELDS.put("Traffic Class", "0x12");
        EXPECTED_FIELDS.put("Flow Label", "0xabcde");
        EXPECTED_FIELDS.put("Payload Length", "1 bytes");
        EXPECTED_FIELDS.put("Next Header", "0xfe");
        EXPECTED_FIELDS.put("Hop Limit", "63");
        EXPECTED_FIELDS.put("Source IP Address", "fedc:ba98:7654:3210:fedc:ba98:7654:3210");
        EXPECTED_FIELDS.put("Destination IP Address", "123:4567:89ab:cdef:123:4567:89ab:cdef");
        StringBuilder sb = new StringBuilder();
        sb.append("Internet Protocol Version 6, Source: fedc:ba98:7654:3210:fedc:ba98:7654:3210, Destination: 123:4567:89ab:cdef:123:4567:89ab:cdef\n");
        sb.append("Version: 6, Header Length: 40 bytes, Traffic Class: 0x12, Flow Label: 0xabcde, Payload Length: 1 bytes\n");
        sb.append("Next Header: 0xfe, Hop Limit: 63\n");
        sb.append("Payload: a6");
        EXPECTED_TOSTRING = sb.toString();
    }

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(41);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)97);
        this.fPacket.put((byte)42);
        this.fPacket.put((byte)-68);
        this.fPacket.put((byte)-34);
        this.fPacket.put((byte)0);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)-2);
        this.fPacket.put((byte)63);
        this.fPacket.put((byte)-2);
        this.fPacket.put((byte)-36);
        this.fPacket.put((byte)-70);
        this.fPacket.put((byte)-104);
        this.fPacket.put((byte)118);
        this.fPacket.put((byte)84);
        this.fPacket.put((byte)50);
        this.fPacket.put((byte)16);
        this.fPacket.put((byte)-2);
        this.fPacket.put((byte)-36);
        this.fPacket.put((byte)-70);
        this.fPacket.put((byte)-104);
        this.fPacket.put((byte)118);
        this.fPacket.put((byte)84);
        this.fPacket.put((byte)50);
        this.fPacket.put((byte)16);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)35);
        this.fPacket.put((byte)69);
        this.fPacket.put((byte)103);
        this.fPacket.put((byte)-119);
        this.fPacket.put((byte)-85);
        this.fPacket.put((byte)-51);
        this.fPacket.put((byte)-17);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)35);
        this.fPacket.put((byte)69);
        this.fPacket.put((byte)103);
        this.fPacket.put((byte)-119);
        this.fPacket.put((byte)-85);
        this.fPacket.put((byte)-51);
        this.fPacket.put((byte)-17);
        this.fPacket.put((byte)-90);
        this.fPacket.flip();
    }

    @Test
    public void CompleteIPv6PacketTest() throws IOException, BadPcapFileException, BadPacketException {
        PcapTestTrace trace = PcapTestTrace.EMPTY_PCAP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile file = trace.getTrace();){
            ByteBuffer byteBuffer = this.fPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"CompleteIPv6PacketTest has failed!");
                return;
            }
            IPv6Packet packet = new IPv6Packet(file, null, byteBuffer);
            Assert.assertEquals((Object)PcapProtocol.IPV6, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.IPV6));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertTrue((boolean)packet.validate());
            IPv6Packet expected = new IPv6Packet(file, null, byteBuffer);
            Assert.assertEquals((long)expected.hashCode(), (long)packet.hashCode());
            Assert.assertEquals((Object)expected, (Object)packet);
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)EXPECTED_TOSTRING, (Object)packet.toString());
            Assert.assertEquals((Object)"Src: fedc:ba98:7654:3210:fedc:ba98:7654:3210 , Dst: 123:4567:89ab:cdef:123:4567:89ab:cdef", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"fedc:ba98:7654:3210:fedc:ba98:7654:3210 > 123:4567:89ab:cdef:123:4567:89ab:cdef Len=1", (Object)packet.getGlobalSummaryString());
            Assert.assertEquals((Object)new IPv6Endpoint(packet, true), (Object)packet.getSourceEndpoint());
            Assert.assertEquals((Object)new IPv6Endpoint(packet, false), (Object)packet.getDestinationEndpoint());
            this.fPacket.position(40);
            byte[] payload = new byte[1];
            this.fPacket.get(payload);
            Assert.assertEquals((Object)ByteBuffer.wrap(payload), (Object)packet.getPayload());
            Assert.assertEquals((Object)InetAddress.getByAddress(Arrays.copyOfRange(this.fPacket.array(), 8, 24)), (Object)packet.getSourceIpAddress());
            Assert.assertEquals((Object)InetAddress.getByAddress(Arrays.copyOfRange(this.fPacket.array(), 24, 40)), (Object)packet.getDestinationIpAddress());
            Assert.assertEquals((long)6L, (long)packet.getVersion());
            Assert.assertEquals((long)40L, (long)packet.getHeaderLength());
            Assert.assertEquals((long)18L, (long)packet.getTrafficClass());
            Assert.assertEquals((long)703710L, (long)packet.getFlowLabel());
            Assert.assertEquals((long)1L, (long)packet.getPayloadLength());
            Assert.assertEquals((long)254L, (long)packet.getNextHeader());
            Assert.assertEquals((long)63L, (long)packet.getHopLimit());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

