/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonFieldClassAliasMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public class FieldClass {
    private final JsonObject fFieldClass;

    public FieldClass(JsonObject fieldClass) {
        this.fFieldClass = fieldClass;
    }

    public JsonObject getFieldClass() {
        return this.fFieldClass;
    }

    public static class FieldClassDeserializer
    implements JsonDeserializer<FieldClass> {
        private final ICTFMetadataNode fRoot;

        public FieldClassDeserializer(ICTFMetadataNode root) {
            this.fRoot = root;
        }

        public FieldClass deserialize(JsonElement jElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (jElement.isJsonPrimitive()) {
                JsonPrimitive jPrimitive = jElement.getAsJsonPrimitive();
                if (jPrimitive.isString()) {
                    String fieldClassAlias = jPrimitive.getAsString();
                    for (ICTFMetadataNode node : this.fRoot.getChildren()) {
                        JsonFieldClassAliasMetadataNode fieldClassAliasNode;
                        if (!(node instanceof JsonFieldClassAliasMetadataNode) || !(fieldClassAliasNode = (JsonFieldClassAliasMetadataNode)node).getName().equals(fieldClassAlias)) continue;
                        return new FieldClass(fieldClassAliasNode.getFieldClass());
                    }
                    throw new JsonParseException("no previously occurring field class alias named '" + fieldClassAlias + "'");
                }
            } else if (jElement.isJsonObject()) {
                JsonObject jObject = jElement.getAsJsonObject();
                return new FieldClass(jObject);
            }
            throw new JsonParseException("field-class property is not a JSON object or JSON string");
        }
    }
}

