/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import org.eclipse.core.runtime.IConfigurationElement;

public class ProcessParameter {
    public static final byte SIMPLE = 1;
    public static final byte SIMPLE_ARRAY = 2;
    public static final byte COMPLEX = 3;
    public static final byte COMPLEX_ARRAY = 4;
    private static final String ELEM_NAME = "name";
    private static final String ELEM_BASE_TYPE = "baseType";
    private static final String ELEM_SIMPLE = "simple";
    private static final String ELEM_SIMPLE_ARRAY = "simpleArray";
    private static final String ELEM_COMPLEX = "complex";
    private static final String ELEM_COMPLEX_ARRAY = "complexArray";
    private static final String ELEM_EXTERNAL = "external";
    private static final String ELEM_NULLABLE = "nullable";
    private String name;
    private byte type;
    private ProcessParameter[] complexChildren;
    private boolean external;
    private boolean nullable;

    public ProcessParameter(IConfigurationElement element) {
        this.name = element.getAttribute(ELEM_NAME);
        String elemName = element.getName();
        if (elemName.equals(ELEM_SIMPLE)) {
            this.type = 1;
        } else if (elemName.equals(ELEM_SIMPLE_ARRAY)) {
            this.type = (byte)2;
        } else if (elemName.equals(ELEM_COMPLEX)) {
            this.type = (byte)3;
            IConfigurationElement[] children = element.getChildren();
            this.complexChildren = new ProcessParameter[children.length];
            int i = 0;
            while (i < children.length) {
                this.complexChildren[i] = new ProcessParameter(children[i]);
                ++i;
            }
        } else if (elemName.equals(ELEM_COMPLEX_ARRAY)) {
            this.type = (byte)4;
            IConfigurationElement baseType = element.getChildren(ELEM_BASE_TYPE)[0];
            IConfigurationElement[] children = baseType.getChildren();
            this.complexChildren = new ProcessParameter[children.length];
            int i = 0;
            while (i < children.length) {
                this.complexChildren[i] = new ProcessParameter(children[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.external = Boolean.valueOf(element.getAttribute(ELEM_EXTERNAL));
        this.nullable = Boolean.valueOf(element.getAttribute(ELEM_NULLABLE));
    }

    public String getName() {
        return this.name;
    }

    public byte getType() {
        return this.type;
    }

    public ProcessParameter[] getComplexChildren() {
        return this.complexChildren;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

